--
-- Tigase Push - Push notifications component for Tigase
-- Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
-- Unauthorized copying of this file, via any medium is strictly prohibited
-- Proprietary and confidential
--

-- QUERY START:
IF NOT EXISTS(SELECT * FROM sys.indexes WHERE object_id = object_id('dbo.tig_push_devices') AND NAME ='IX_tig_push_devices_provider_user_jid_sha1')
CREATE INDEX IX_tig_push_devices_provider_user_jid_sha1 ON [dbo].[tig_push_devices](provider, user_jid_sha1);
-- QUERY END:
GO

-- QUERY START:
IF EXISTS (SELECT * FROM sys.objects WHERE type = 'P' AND name = 'Tig_Push_Stats')
DROP PROCEDURE Tig_Push_Stats
-- QUERY END:
    GO

-- QUERY START:
create procedure dbo.Tig_Push_Stats
    AS
begin
select 'all', provider, count(1) from tig_push_devices group by provider
union all select 'accounts', provider, count(distinct user_jid_sha1) from tig_push_devices group by provider;
end
-- QUERY END:
GO
