--
-- Tigase Push - Push notifications component for Tigase
-- Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
-- Unauthorized copying of this file, via any medium is strictly prohibited
-- Proprietary and confidential
--

-- QUERY START:
drop procedure if exists TigPushUpgrade;
-- QUERY END:

delimiter //

-- QUERY START:
create procedure TigPushUpgrade()
begin
    if not exists(SELECT 1 FROM information_schema.statistics s1 WHERE s1.table_schema = database() AND s1.table_name = 'tig_push_devices' AND s1.index_name = 'tig_push_devices_provider_user_jid_sha1') then
        create index tig_push_devices_provider_user_jid_sha1 on tig_push_devices (provider, user_jid_sha1);
    end if;
end //
-- QUERY END:

delimiter ;

-- QUERY START:
call TigPushUpgrade();
-- QUERY END:

-- QUERY START:
drop procedure if exists TigPushUpgrade;
-- QUERY END:

-- QUERY START:
drop procedure if exists Tig_Push_Stats;
-- QUERY END:

delimiter //

-- QUERY START:
create procedure Tig_Push_Stats()
begin
select 'all', provider, count(1) from tig_push_devices group by provider union all select 'accounts', provider, count(distinct user_jid_sha1) from tig_push_devices group by provider;
end //
-- QUERY END:
delimiter ;
