/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.monitor;

import java.time.LocalDateTime;
import java.util.stream.Stream;

public interface SSLCertificateExpirationAware {
    public Stream<Result> getSSLCertificatesValidPeriod();

    public static class Result {
        private final String a;
        private final LocalDateTime b;
        private final LocalDateTime c;

        public Result(String name, LocalDateTime validFrom, LocalDateTime validTo) {
            this.a = name;
            this.b = validFrom;
            this.c = validTo;
        }

        public String getName() {
            return this.a;
        }

        public LocalDateTime getValidFrom() {
            return this.b;
        }

        public LocalDateTime getValidTo() {
            return this.c;
        }

        public boolean isValid(LocalDateTime date) {
            return this.b.isBefore(date) && this.c.isAfter(date);
        }
    }
}

