/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.monitor;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusEvent;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.monitor.MonitorComponent;
import tigase.monitor.tasks.AbstractConfigurableTimerTask;
import tigase.monitor.tasks.TasksEvent;
import tigase.push.monitor.SSLCertificateExpirationAware;
import tigase.util.datetime.TimestampHelper;
import tigase.xml.XMLUtils;

@Bean(name="push-ssl-certificate-expiration-checker-task", parent=MonitorComponent.class, active=true)
public class MonitorSSLCertificatesExpirationCheckerTask
extends AbstractConfigurableTimerTask {
    private static final Logger a = Logger.getLogger(MonitorSSLCertificatesExpirationCheckerTask.class.getCanonicalName());
    private static final String b = "tigase.monitor.tasks.push.MonitorSSLCertificatesExpirationTask";
    private static final String c = "still-valid-in";
    private static final TimestampHelper d = new TimestampHelper();
    @Inject
    private EventBus eventBus;
    @Inject
    private MonitorComponent component;
    @Inject(nullAllowed=true)
    private List<SSLCertificateExpirationAware> containers = Collections.emptyList();
    private int e = 7;
    private ConcurrentHashMap<String, Long> f = new ConcurrentHashMap();

    public MonitorSSLCertificatesExpirationCheckerTask() {
        this.setPeriod(3600000L);
    }

    public List<SSLCertificateExpirationAware> getContainers() {
        return this.containers;
    }

    public void setContainers(List<SSLCertificateExpirationAware> containers) {
        this.containers = Optional.ofNullable(containers).orElse(Collections.emptyList());
    }

    public Form getCurrentConfiguration() {
        Form form = super.getCurrentConfiguration();
        form.addField(Field.fieldTextSingle((String)c, (String)("" + this.e), (String)"Check if certificates are still valid in [days]"));
        return form;
    }

    public void setNewConfiguration(Form form) {
        Field field = form.get(c);
        if (field != null) {
            this.e = Integer.parseInt(field.getValue());
        }
        super.setNewConfiguration(form);
    }

    protected void run() {
        this.checkPushCertificatesValidation();
    }

    protected void checkPushCertificatesValidation() {
        if (a.isLoggable(Level.FINE)) {
            a.log(Level.FINE, "Checking SSL certificates for " + String.valueOf(this.containers));
        }
        List list = this.containers.stream().flatMap(SSLCertificateExpirationAware::getSSLCertificatesValidPeriod).collect(Collectors.toList());
        for (SSLCertificateExpirationAware.Result result : list) {
            if (result.isValid(LocalDateTime.now()) && result.isValid(LocalDateTime.now().plusDays(this.e))) {
                this.f.remove(result.getName());
                continue;
            }
            a a2 = new a(result);
            long l = LocalDateTime.now().until(result.getValidTo(), ChronoUnit.DAYS);
            Consumer<Level> consumer = level -> {
                if (!result.isValid(LocalDateTime.now())) {
                    a.log((Level)level, () -> "Certificate " + result.getName() + " is not valid!");
                } else {
                    a.log((Level)level, () -> "Certificate " + result.getName() + " will expire in " + l + " days");
                }
            };
            long l2 = Optional.ofNullable(this.f.put(result.getName(), l)).orElse(Long.MAX_VALUE);
            if (l != l2) {
                consumer.accept(Level.WARNING);
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "Firing event: " + String.valueOf((Object)a2));
                }
                this.eventBus.fire((EventBusEvent)a2);
                continue;
            }
            consumer.accept(Level.FINEST);
        }
    }

    static class a
    extends TasksEvent {
        private final SSLCertificateExpirationAware.Result a;
        private final String b;
        private final String c;
        private final String d;

        public a(SSLCertificateExpirationAware.Result result) {
            super("APNSCertificatesExpirationEvent: " + result.getName(), "Fired when APNS Push Certificate reaches validity expiration");
            this.a = result;
            this.b = result.getValidFrom().format(DateTimeFormatter.ISO_DATE_TIME);
            this.c = result.getValidTo().format(DateTimeFormatter.ISO_DATE_TIME);
            if (!result.isValid(LocalDateTime.now())) {
                this.d = XMLUtils.escape((String)("Certificate " + result.getName() + " is not valid!"));
            } else {
                long l = LocalDateTime.now().until(result.getValidTo(), ChronoUnit.DAYS);
                this.d = XMLUtils.escape((String)("Certificate " + result.getName() + " will expire in " + l + " days"));
            }
        }

        public Map<String, String> getAdditionalData() {
            return Map.of("valid-from", this.b, "valid-to", this.c, "message", this.d);
        }
    }
}

