/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.modules;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.component.modules.AbstractModule;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.db.UserRepository;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.push.EncryptedNotification;
import tigase.push.PlainNotification;
import tigase.push.PushNotificationsComponent;
import tigase.push.api.INotification;
import tigase.push.api.IPushProvider;
import tigase.push.api.IPushRepository;
import tigase.push.api.IPushSettings;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLUtils;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="publish-notification", parent=PushNotificationsComponent.class, active=true)
public class PublishNotificationModule
extends AbstractModule {
    private static final String a = "urn:xmpp:push:0";
    private static final String b = "http://jabber.org/protocol/pubsub";
    private static final Criteria c = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"publish"));
    private String[] d = new String[]{"urn:xmpp:push:0"};
    @Inject(nullAllowed=true)
    private List<IPushProvider> pushProviders;
    private Map<String, IPushProvider> e;
    @Inject
    private IPushRepository repository;
    @ConfigField(desc="Default priority of notifications", alias="def-priority")
    private INotification.Priority defPriority = INotification.Priority.high;

    private static void a(BareJID bareJID, String string) throws ComponentException {
        throw new ComponentException(Authorization.ITEM_NOT_FOUND, "Node " + string + " not found at " + String.valueOf(bareJID));
    }

    public String[] getFeatures() {
        return this.d;
    }

    public Criteria getModuleCriteria() {
        return c;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        Element element = packet.getElement().getChild("pubsub").getChild("publish");
        String string2 = element.getAttributeStaticStr("node");
        if (string2 == null) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Missing node attribute");
        }
        Element element2 = element.getChild("item");
        if (element2 == null) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Missing item to push");
        }
        Element element3 = element2.getChild("notification", a);
        if (element3 == null) {
            throw new ComponentException(Authorization.BAD_REQUEST, "Missing notification to push");
        }
        try {
            ((CompletableFuture)this.pushNotification(packet.getStanzaTo().getBareJID(), packet.getStanzaFrom().getBareJID(), string2, element3).thenAccept(string -> {
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.log(Level.FINEST, "push notification for request from " + String.valueOf(packet.getStanzaFrom()) + " with id " + packet.getStanzaId() + " sent in notification with id " + string);
                }
                this.write(packet.okResult((Element)null, 0));
            })).exceptionally(throwable -> {
                this.handlePushNotificationException(packet, (Throwable)throwable);
                return null;
            });
        }
        catch (RepositoryException repositoryException) {
            throw new RuntimeException(repositoryException);
        }
    }

    public void handlePushNotificationException(Packet packet, Throwable ex) {
        block7: {
            if (ex instanceof CompletionException) {
                this.handlePushNotificationException(packet, ex.getCause());
            } else {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "push notification for request from " + String.valueOf(packet.getStanzaFrom()) + " with id " + packet.getStanzaId() + " failed", ex);
                }
                try {
                    if (ex instanceof ComponentException) {
                        this.write(((ComponentException)ex).getErrorCondition().getResponseMessage(packet, ex.getMessage(), false));
                    } else {
                        this.write(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, null, false));
                    }
                }
                catch (PacketErrorTypeException packetErrorTypeException) {
                    if (!this.log.isLoggable(Level.FINEST)) break block7;
                    this.log.log(Level.WARNING, "could not send response", packetErrorTypeException);
                }
            }
        }
    }

    public void setPushProviders(List<IPushProvider> pushProviders) {
        if (pushProviders == null) {
            pushProviders = Collections.emptyList();
        }
        this.pushProviders = pushProviders;
        this.e = pushProviders.stream().collect(Collectors.toConcurrentMap(iPushProvider -> iPushProvider.getName(), Function.identity()));
        this.d = (String[])Stream.concat(Stream.of(a), this.pushProviders.stream().map(iPushProvider -> iPushProvider.getName())).toArray(String[]::new);
    }

    @HandleEvent
    public void onUserRemoval(UserRepository.UserRemovedEvent event) {
    }

    protected IPushProvider getProvider(IPushSettings.IDevice device) {
        return this.e.get(device.getProviderName());
    }

    protected CompletableFuture<String> pushNotification(BareJID serviceJid, BareJID senderJid, String node, Element notificationElem) throws ComponentException, TigaseStringprepException, RepositoryException {
        IPushSettings iPushSettings = this.repository.getNodeSettings(serviceJid, node, PublishNotificationModule::a);
        if (!iPushSettings.isOwner(senderJid) && !iPushSettings.getOwnerJid().getDomain().equals(senderJid.getDomain())) {
            throw new ComponentException(Authorization.FORBIDDEN, "Cannot publish item - you are not node owner");
        }
        INotification iNotification = this.parseNotification(iPushSettings.getOwnerJid(), notificationElem);
        if (iPushSettings.getVersion() == 0) {
            CompletableFuture<String> completableFuture = new CompletableFuture<String>();
            for (IPushSettings.IDevice iDevice : iPushSettings.getDevices()) {
                IPushProvider iPushProvider = this.getProvider(iDevice);
                if (iPushProvider == null) {
                    this.log.log(Level.FINE, "Could not send push notification to provider " + iDevice.getProviderName() + " - missing push provider!");
                    continue;
                }
                ((CompletableFuture)iPushProvider.pushNotification(iDevice, iNotification).thenAccept(string -> completableFuture.complete((String)string))).exceptionally(throwable -> {
                    completableFuture.completeExceptionally((Throwable)throwable);
                    return null;
                });
            }
            return completableFuture;
        }
        IPushSettings.IDevice iDevice = iPushSettings.getDevices().get(0);
        IPushProvider iPushProvider = this.getProvider(iDevice);
        if (iPushProvider == null) {
            return CompletableFuture.failedFuture(new ComponentException(Authorization.SERVICE_UNAVAILABLE, "Push provider not available"));
        }
        return iPushProvider.pushNotification(iDevice, iNotification);
    }

    protected Optional<INotification.Priority> guessPriority(Element notificationElem) {
        return Optional.ofNullable(notificationElem.getChild("x", "jabber:x:data")).map(element -> {
            if (DataForm.getFieldValue((Element)element, (String)"last-message-body") != null) {
                return INotification.Priority.high;
            }
            if (DataForm.getFieldValue((Element)element, (String)"message-count") != null) {
                return INotification.Priority.low;
            }
            return INotification.Priority.high;
        });
    }

    protected INotification.Priority parsePriority(Element notificationElem) {
        return Optional.ofNullable(notificationElem.getChild("priority", "tigase:push:priority:0")).map(Element::getCData).map(INotification.Priority::valueOf).or(() -> this.guessPriority(notificationElem)).orElse(INotification.Priority.low);
    }

    protected INotification.Jingle parseJingle(Element notificationElem) {
        return Optional.ofNullable(notificationElem.getChild("jingle", "tigase:push:jingle:0")).map(element -> {
            String string = element.getAttributeStaticStr("sid");
            if (string == null) {
                return null;
            }
            return new INotification.Jingle(string, element.mapChildren(Element::getCData));
        }).orElse(null);
    }

    protected INotification.Meet parseMeet(Element notificationElem) {
        return Optional.ofNullable(notificationElem.getChild("meet", "tigase:push:meet:0")).map(element -> {
            String string = element.getAttributeStaticStr("id");
            if (string == null) {
                return null;
            }
            String string2 = element.getAttributeStaticStr("jid");
            if (string2 == null) {
                return null;
            }
            return new INotification.Meet(string2, string, element.mapChildren(Element::getCData));
        }).orElse(null);
    }

    protected INotification parseNotification(BareJID userJid, Element notificationElem) throws ComponentException, TigaseStringprepException {
        INotification.Priority priority = this.parsePriority(notificationElem);
        Element element = notificationElem.getChild("encrypted", "tigase:push:encrypt:0");
        if (element == null) {
            Element element2;
            Long l = this.parseLong(notificationElem, "message-count");
            JID jID = this.parseJID(notificationElem, "last-message-sender");
            String string = DataForm.getFieldValue((Element)notificationElem, (String)"last-message-body");
            String string2 = null;
            Element element3 = notificationElem.getChild("groupchat", "http://tigase.org/protocol/muc#offline");
            if (element3 != null && (element2 = element3.getChild("nickname")) != null) {
                string2 = XMLUtils.unescape((String)element2.getCData());
            }
            element2 = notificationElem.getChild("event", "http://tigase.org/protocol/account#event");
            String string3 = null;
            if (element2 != null) {
                string3 = element2.getAttributeStaticStr("name");
            }
            INotification.Jingle jingle = this.parseJingle(notificationElem);
            INotification.Meet meet = this.parseMeet(notificationElem);
            return new PlainNotification(userJid, priority, l, jID, string, string2, string3, jingle, meet);
        }
        INotification.Type type = "voip".equals(element.getAttributeStaticStr("type")) ? INotification.Type.voip : INotification.Type.normal;
        return new EncryptedNotification(userJid, priority, type, element.getCData(), element.getAttributeStaticStr("iv"));
    }

    protected Long parseLong(Element elem, String field) {
        String string = DataForm.getFieldValue((Element)elem, (String)field);
        if (string == null || string.isEmpty()) {
            return null;
        }
        return Long.parseLong(string);
    }

    protected JID parseJID(Element elem, String field) throws ComponentException, TigaseStringprepException {
        String string = DataForm.getFieldValue((Element)elem, (String)field);
        if (string == null || string.isEmpty()) {
            return null;
        }
        return JID.jidInstance((String)string);
    }
}

