/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.apns;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApnsPayload {
    private final Map<String, Object> a;
    private final Map<String, Object> b;
    private final Map<String, Object> c;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ApnsPayload(Builder builder) {
        this.a = builder.a;
        this.b = builder.b;
        this.c = builder.c;
    }

    public Integer badge() {
        return (Integer)this.a.get("badge");
    }

    public String body() {
        return (String)this.b.get("body");
    }

    public String title() {
        return (String)this.b.get("title");
    }

    public Object customField(String key) {
        return this.c.get(key);
    }

    public String toPayloadString() {
        if (!this.b.isEmpty()) {
            this.a.put("alert", this.b);
        }
        if (!this.a.isEmpty()) {
            this.c.put("aps", this.a);
        }
        StringBuilder stringBuilder = new StringBuilder();
        ApnsPayload.a(this.c, stringBuilder);
        return stringBuilder.toString();
    }

    private static void a(Object object, StringBuilder stringBuilder) {
        if (object instanceof Integer) {
            stringBuilder.append((Integer)object);
        } else if (object instanceof Double) {
            stringBuilder.append((Double)object);
        } else if (object instanceof String) {
            ApnsPayload.a((String)object, stringBuilder);
        } else if (object instanceof List) {
            stringBuilder.append("[");
            boolean bl = true;
            for (Object e : (List)object) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                ApnsPayload.a(e, stringBuilder);
            }
            stringBuilder.append("]");
        } else if (object instanceof Map) {
            stringBuilder.append("{");
            boolean bl = true;
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("\"").append(entry.getKey()).append("\" : ");
                ApnsPayload.a(entry.getValue(), stringBuilder);
            }
            stringBuilder.append("}");
        } else {
            stringBuilder.append("null");
        }
    }

    private static void a(String string, StringBuilder stringBuilder) {
        stringBuilder.append('\"');
        block8: for (char c : string.toCharArray()) {
            switch (c) {
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block8;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block8;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block8;
                }
                case '\"': 
                case '/': 
                case '\\': {
                    stringBuilder.append("\\");
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        stringBuilder.append('\"');
    }

    public static class Builder {
        private Map<String, Object> a = new HashMap<String, Object>();
        private Map<String, Object> b = new HashMap<String, Object>();
        private Map<String, Object> c = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder badge(Integer badge) {
            this.a(this.a, "badge", badge);
            return this;
        }

        public Builder sound(String sound) {
            this.a(this.a, "sound", sound);
            return this;
        }

        public Builder title(String title) {
            return this.a(this.b, "title", title);
        }

        public boolean hasTitle() {
            return this.a(this.b, "title");
        }

        public Builder subtitle(String subtitle) {
            return this.a(this.b, "subtitle", subtitle);
        }

        public boolean hasSubtitle() {
            return this.a(this.b, "subtitle");
        }

        public Builder body(String body) {
            return this.a(this.b, "body", body);
        }

        public boolean hasBody() {
            return this.a(this.b, "body");
        }

        public Builder category(String category) {
            return this.a(this.a, "category", category);
        }

        public Builder threadId(String threadId) {
            return this.a(this.a, "thread-id", threadId);
        }

        public Builder instantDeliveryOrSilentNotification() {
            return this.contentAvailable(1);
        }

        public Builder contentAvailable(Integer value) {
            return this.a(this.a, "content-available", value);
        }

        public Builder mutableContent(Integer value) {
            return this.a(this.a, "mutable-content", value);
        }

        public Builder customField(String name, Object value) {
            return this.a(this.c, name, value);
        }

        public ApnsPayload build() {
            return new ApnsPayload(this);
        }

        private boolean a(Map<String, Object> map, String string) {
            return map != null && map.containsKey(string);
        }

        private Builder a(Map<String, Object> map, String string, Object object) {
            if (object != null) {
                map.put(string, object);
            } else {
                map.remove(string);
            }
            return this;
        }
    }
}

