/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.adhoc;

import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.exceptions.RepositoryException;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.push.PushNotificationsComponent;
import tigase.push.adhoc.AbstractAdHocCommand;
import tigase.push.adhoc.SetAPNSEncryptionKey;
import tigase.push.api.IPushProvider;
import tigase.push.fcm.Credentials;
import tigase.push.fcm.FcmHttpV1Provider;
import tigase.xml.XMLUtils;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

@Bean(name="set-fcm-service-account", parent=PushNotificationsComponent.class, active=true)
public class SetFCMServiceAccount
extends AbstractAdHocCommand {
    private static final Logger b = Logger.getLogger(SetAPNSEncryptionKey.class.getCanonicalName());
    @Inject
    PushNotificationsComponent a;
    @Inject(nullAllowed=true)
    private List<FcmHttpV1Provider> pushProviders;

    public String getName() {
        return "Set FCM service account";
    }

    public String getNode() {
        return "set-fcm-service-account";
    }

    public boolean isAllowedFor(JID jid) {
        return this.a.isAdmin(jid);
    }

    @Override
    protected Form prepareForm(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        Form form = new Form("form", "Select FCM provider to set FCM service account", "Use this form to set FCM service account for push provider");
        String[] stringArray = new String[this.pushProviders.size()];
        String[] stringArray2 = new String[this.pushProviders.size()];
        for (int i = 0; i < this.pushProviders.size(); ++i) {
            IPushProvider iPushProvider = this.pushProviders.get(i);
            stringArray[i] = iPushProvider.getDescription() + ": " + iPushProvider.getName();
            stringArray2[i] = iPushProvider.getName();
        }
        form.addField(Field.fieldListSingle((String)"provider", (String)"", (String)"Provider", (String[])stringArray, (String[])stringArray2));
        form.addField(Field.fieldTextMulti((String)"service-account", (String)"", (String)"Service account JSON file content"));
        return form;
    }

    @Override
    protected Form submitForm(AdhHocRequest request, AdHocResponse response, Form form) throws AdHocCommandException {
        String string = form.getAsString("provider");
        String string2 = XMLUtils.unescape((String)Optional.ofNullable(form.getAsStrings("service-account")).map(stringArray -> String.join((CharSequence)"\n", stringArray)).orElse(""));
        if (string == null || string2.isBlank()) {
            throw new AdHocCommandException(Authorization.BAD_REQUEST, "Provider and service account must not be empty and service account must be a valid JSON service account file content.");
        }
        try {
            Credentials.fromString(string2);
        }
        catch (Exception exception) {
            b.log(Level.FINEST, "Invalid ad-hoc payload", exception);
            throw new AdHocCommandException(Authorization.BAD_REQUEST, "Service account is not a valid JSON service account file content!");
        }
        FcmHttpV1Provider fcmHttpV1Provider2 = this.pushProviders.stream().filter(fcmHttpV1Provider -> fcmHttpV1Provider.getName().equals(string)).findAny().orElseThrow(() -> new AdHocCommandException(Authorization.BAD_REQUEST, "Unsupported push provider"));
        try {
            fcmHttpV1Provider2.setServiceAccountContent(string2);
            Form form2 = new Form("result", "FCM service account updated", "FCM service account updated");
            form2.addField(Field.fieldFixed((String)"FCM service account updated"));
            response.completeSession();
            return form2;
        }
        catch (RepositoryException repositoryException) {
            throw new RuntimeException(repositoryException);
        }
    }
}

