/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.adhoc;

import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.exceptions.RepositoryException;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.push.PushNotificationsComponent;
import tigase.push.adhoc.AbstractAdHocCommand;
import tigase.push.api.IPushProvider;
import tigase.push.apns.APNsBinaryApiProvider;
import tigase.util.Base64;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

@Bean(name="set-apns-certificate", parent=PushNotificationsComponent.class, active=true)
public class SetAPNSCertificate
extends AbstractAdHocCommand {
    private static final Logger b = Logger.getLogger(SetAPNSCertificate.class.getCanonicalName());
    @Inject
    PushNotificationsComponent a;
    @Inject(nullAllowed=true)
    private List<APNsBinaryApiProvider> pushProviders;

    public String getName() {
        return "Set APNS certificate";
    }

    public String getNode() {
        return "set-apns-certificate";
    }

    public boolean isAllowedFor(JID jid) {
        return this.a.isAdmin(jid);
    }

    @Override
    protected Form prepareForm(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        Form form = new Form("form", "Select APNS provider to set APNS certificate", "Use this form to set APNS certificate for push provider");
        String[] stringArray = new String[this.pushProviders.size()];
        String[] stringArray2 = new String[this.pushProviders.size()];
        for (int i = 0; i < this.pushProviders.size(); ++i) {
            IPushProvider iPushProvider = this.pushProviders.get(i);
            stringArray[i] = iPushProvider.getDescription() + ": " + iPushProvider.getName();
            stringArray2[i] = iPushProvider.getName();
        }
        form.addField(Field.fieldListSingle((String)"provider", (String)"", (String)"Provider", (String[])stringArray, (String[])stringArray2));
        form.addField(Field.fieldTextMulti((String)"apns-certificate", (String)"", (String)"APNS certificate"));
        form.addField(Field.fieldTextMulti((String)"apns-pushkit-certificate", (String)"", (String)"APNS pushkit certificate"));
        form.addField(Field.fieldTextPrivate((String)"apns-certificate-password", (String)"", (String)"APNS certificate password"));
        return form;
    }

    @Override
    protected Form submitForm(AdhHocRequest request, AdHocResponse response, Form form) throws AdHocCommandException {
        String string = form.getAsString("provider");
        String string2 = form.getAsStrings("apns-certificate") == null ? null : String.join((CharSequence)"", form.getAsStrings("apns-certificate"));
        String string3 = form.getAsStrings("apns-pushkit-certificate") == null ? null : String.join((CharSequence)"", form.getAsStrings("apns-pushkit-certificate"));
        String string4 = form.getAsString("apns-certificate-password");
        if (string == null || string2 == null || string2.isEmpty() || string3 == null || string3.isEmpty() || string4 == null || string4.isEmpty()) {
            throw new AdHocCommandException(Authorization.BAD_REQUEST, "Provider and certificate must not be empty and certificates must be encoded as valid Base64");
        }
        try {
            Base64.decode((String)string2);
            Base64.decode((String)string3);
        }
        catch (Exception exception) {
            b.log(Level.FINEST, "Invalid ad-hoc payload", exception);
            throw new AdHocCommandException(Authorization.BAD_REQUEST, "Certificates must be encoded as valid Base64");
        }
        Optional<APNsBinaryApiProvider> optional = this.pushProviders.stream().filter(aPNsBinaryApiProvider -> aPNsBinaryApiProvider.getName().equals(string)).findAny();
        if (optional.isEmpty()) {
            throw new AdHocCommandException(Authorization.BAD_REQUEST, "Unsupported push provider");
        }
        try {
            optional.get().setAPNSCertificate(string2, string3, string4);
            Form form2 = new Form("result", "APNS certificate updated", "APNS certificate updated");
            form2.addField(Field.fieldFixed((String)"APNS certificate updated"));
            response.completeSession();
            return form2;
        }
        catch (RepositoryException repositoryException) {
            throw new RuntimeException(repositoryException);
        }
    }
}

