/*
 * Decompiled with CFR 0.152.
 */
package tigase.push;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.pubsub.Affiliation;
import tigase.push.api.IPushProvider;
import tigase.push.api.IPushRepository;
import tigase.push.api.IPushSettings;
import tigase.push.modules.AffiliationChangedModule;
import tigase.stats.ComponentStatisticsProvider;
import tigase.stats.Counter;
import tigase.stats.StatisticsList;
import tigase.xmpp.jid.BareJID;

public abstract class AbstractProvider
implements IPushProvider,
ComponentStatisticsProvider {
    private static final Logger a = Logger.getLogger(AbstractProvider.class.getName());
    @Inject
    private AffiliationChangedModule affiliationChangedModule;
    @Inject
    private IPushRepository repository;
    @Inject
    private UserRepository userRepository;
    private boolean b = false;
    private final Counter c = new Counter("Number of push notifications sent", Level.FINE);
    private final Counter d = new Counter("Number of failed push notifications", Level.FINE);
    @ConfigField(desc="Provider name")
    private String name;
    private final BareJID e = BareJID.bareJIDInstanceNS((String)"push");

    protected AbstractProvider(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
        this.b = false;
    }

    public void everyHour() {
        this.c.everyHour();
        this.d.everyHour();
    }

    public void everyMinute() {
        this.c.everyMinute();
        this.d.everyMinute();
    }

    public void everySecond() {
        this.c.everySecond();
        this.d.everySecond();
    }

    public void getStatistics(String compName, StatisticsList list) {
        this.c.getStatistics(compName + "/" + this.getName(), list);
        this.d.getStatistics(compName + "/" + this.getName(), list);
    }

    private void a() throws TigaseDBException {
        if (!this.b) {
            Objects.requireNonNull(this.userRepository);
            if (!this.userRepository.userExists(this.e)) {
                try {
                    this.userRepository.addUser(this.e);
                    this.b = true;
                }
                catch (TigaseDBException tigaseDBException) {
                    if (!this.userRepository.userExists(this.e)) {
                        a.log(Level.WARNING, "failed to initialize data repository", tigaseDBException);
                    }
                    this.b = true;
                }
            }
        }
    }

    protected String getData(String key) throws TigaseDBException {
        this.a();
        return this.userRepository.getData(this.e, this.name, key);
    }

    protected Map<String, String> getDataMap(String ... keys) throws TigaseDBException {
        this.a();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : keys) {
            String string2 = this.userRepository.getData(this.e, this.name, string);
            if (string2 == null) continue;
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    protected void setData(String key, String value) throws TigaseDBException {
        this.a();
        this.userRepository.setData(this.e, this.name, key, value);
    }

    protected void removeData(String ... keys) throws TigaseDBException {
        this.a();
        for (String string : keys) {
            this.userRepository.removeData(this.e, this.name, string);
        }
    }

    protected void unregisterDevice(String deviceId) {
        try {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "unregistering device " + deviceId + " as it was reported as inactive by " + this.getName());
            }
            Stream<IPushSettings> stream = this.repository.getNodeSettings(this.getName(), deviceId);
            stream.forEach(iPushSettings -> {
                try {
                    IPushSettings iPushSettings2 = this.repository.unregisterDevice(iPushSettings.getServiceJid(), iPushSettings.getOwnerJid(), this.getName(), deviceId);
                    if (iPushSettings2 != null && (iPushSettings2.getDevices().isEmpty() || iPushSettings2.getVersion() > 0)) {
                        this.affiliationChangedModule.notifyAffiliationChanged(iPushSettings2.getServiceJid(), iPushSettings2.getOwnerJid(), iPushSettings2.getNode(), Affiliation.none);
                    }
                }
                catch (ComponentException componentException) {
                    a.log(Level.FINER, this.getName() + ", failed to unregister device = " + deviceId, componentException);
                }
                catch (RepositoryException repositoryException) {
                    a.log(Level.WARNING, this.getName() + ", failed to unregister device = " + deviceId, repositoryException);
                }
            });
        }
        catch (RepositoryException repositoryException) {
            a.log(Level.WARNING, this.getName() + ", failed to unregister device = " + deviceId, repositoryException);
        }
    }

    protected void sendingPush() {
        this.c.inc();
    }

    protected void pushFailed() {
        this.d.inc();
    }
}

