/*
 * Decompiled with CFR 0.152.
 */
package tigase.push.apns;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.LogManager;
import org.junit.Assert;
import org.junit.Test;
import tigase.push.Device;
import tigase.push.PlainNotification;
import tigase.push.api.INotification;
import tigase.push.api.IPushSettings;
import tigase.push.apns.APNsBinaryApiProvider;
import tigase.push.apns.ApnsPayload;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class APNSProviderTest {
    private final String account = System.getProperty("account", "test@example.com");
    private final String sender = System.getProperty("sender");
    private final String deviceId = System.getProperty("deviceId");
    private final String pushkitDeviceId = System.getProperty("pushKitDeviceId");
    private final String encryptionKeyId = System.getProperty("encryptionKeyId");
    private final String encryptionKey = System.getProperty("encryptionKey");
    private final String teamId = System.getProperty("teamId");

    @Test
    public void testProvider() throws NoSuchFieldException, IllegalAccessException, InterruptedException, IOException, TigaseStringprepException, ExecutionException {
        if (this.encryptionKey == null) {
            return;
        }
        LogManager.getLogManager().readConfiguration(new ByteArrayInputStream("handlers=java.util.logging.ConsoleHandler\ntigase.push.apns.level=ALL\ntigase.jaxmpp.j2se.connectors.socket.SocketConnector.level=ALL\njava.util.logging.ConsoleHandler.level=FINEST".getBytes()));
        APNsBinaryApiProvider provider = new APNsBinaryApiProvider();
        Field f = provider.getClass().getDeclaredField("encryptionKeyId");
        f.setAccessible(true);
        f.set(provider, this.encryptionKeyId);
        f = provider.getClass().getDeclaredField("encryptionKey");
        f.setAccessible(true);
        f.set(provider, this.encryptionKey);
        f = provider.getClass().getDeclaredField("teamId");
        f.setAccessible(true);
        f.set(provider, this.teamId);
        f = provider.getClass().getDeclaredField("fallbackToSandbox");
        f.setAccessible(true);
        f.set(provider, true);
        f = provider.getClass().getDeclaredField("apnsTopic");
        f.setAccessible(true);
        f.set(provider, "org.tigase.tygrys.custom.atom");
        f = provider.getClass().getDeclaredField("notificationType");
        f.setAccessible(true);
        f.set(provider, APNsBinaryApiProvider.NotificationType.automatic);
        provider.beanConfigurationChanged(Arrays.asList("encryptionKey"));
        Device device = new Device("dummy", this.deviceId, null);
        for (int i = 0; i < 1; ++i) {
            PlainNotification plainNotification = new PlainNotification(BareJID.bareJIDInstance((String)this.account), INotification.Priority.high, null, null, "New message 123!", null);
            CompletableFuture future = provider.pushNotification((IPushSettings.IDevice)device, (INotification)plainNotification);
            String apnsId = (String)future.get();
            Assert.assertNotNull((String)"APNS ID is NULL!", (Object)apnsId);
            System.out.println("send push notification with id " + apnsId);
        }
        Thread.sleep(1000L);
    }

    @Test
    public void testProvider_jingle() throws NoSuchFieldException, IllegalAccessException, InterruptedException, IOException, TigaseStringprepException, ExecutionException {
        if (this.encryptionKey == null) {
            return;
        }
        LogManager.getLogManager().readConfiguration(new ByteArrayInputStream("handlers=java.util.logging.ConsoleHandler\ntigase.push.apns.level=ALL\ntigase.jaxmpp.j2se.connectors.socket.SocketConnector.level=ALL\njava.util.logging.ConsoleHandler.level=FINEST".getBytes()));
        APNsBinaryApiProvider provider = new APNsBinaryApiProvider();
        Field f = provider.getClass().getDeclaredField("encryptionKeyId");
        f.setAccessible(true);
        f.set(provider, this.encryptionKeyId);
        f = provider.getClass().getDeclaredField("encryptionKey");
        f.setAccessible(true);
        f.set(provider, this.encryptionKey);
        f = provider.getClass().getDeclaredField("teamId");
        f.setAccessible(true);
        f.set(provider, this.teamId);
        f = provider.getClass().getDeclaredField("fallbackToSandbox");
        f.setAccessible(true);
        f.set(provider, true);
        f = provider.getClass().getDeclaredField("apnsTopic");
        f.setAccessible(true);
        f.set(provider, "org.tigase.tygrys.custom.atom");
        f = provider.getClass().getDeclaredField("notificationType");
        f.setAccessible(true);
        f.set(provider, APNsBinaryApiProvider.NotificationType.automatic);
        provider.beanConfigurationChanged(Arrays.asList("encryptionKey"));
        Device device = new Device("dummy", this.deviceId, this.pushkitDeviceId);
        for (int i = 0; i < 1; ++i) {
            PlainNotification plainNotification = new PlainNotification(BareJID.bareJIDInstance((String)this.account), INotification.Priority.high, null, JID.jidInstance((String)this.sender), null, null, null, new INotification.Jingle("test", List.of("audio", "video")), null);
            CompletableFuture future = provider.pushNotification((IPushSettings.IDevice)device, (INotification)plainNotification);
            String apnsId = (String)future.get();
            Assert.assertNotNull((String)"APNS ID is NULL!", (Object)apnsId);
            System.out.println("send push notification with id " + apnsId);
        }
        Thread.sleep(1000L);
    }

    @Test
    public void payloadGenerationTest() throws TigaseStringprepException, NoSuchFieldException, IllegalAccessException {
        APNsBinaryApiProvider provider = new APNsBinaryApiProvider();
        PlainNotification plainNotification = new PlainNotification(BareJID.bareJIDInstance((String)this.account), INotification.Priority.high, null, null, "New message 123!", null);
        ApnsPayload.Builder builder = ApnsPayload.newBuilder();
        builder = provider.preparePayload(builder, (INotification)plainNotification, APNsBinaryApiProvider.NotificationType.automatic);
        ApnsPayload payload = builder.build();
        Assert.assertEquals((Object)plainNotification.getAccount().toString(), (Object)payload.customField("account"));
        Assert.assertEquals((Object)plainNotification.getMessageCount(), (Object)payload.customField("unread-messages"));
        Assert.assertEquals((Object)plainNotification.getLastMessageBody(), (Object)payload.customField("body"));
        Assert.assertNull((Object)payload.badge());
        builder = ApnsPayload.newBuilder();
        Field f = APNsBinaryApiProvider.class.getDeclaredField("includeAccountInPayload");
        f.setAccessible(true);
        f.set(provider, false);
        builder = provider.preparePayload(builder, (INotification)plainNotification, APNsBinaryApiProvider.NotificationType.automatic);
        payload = builder.build();
        Assert.assertNull((Object)payload.customField("account"));
        Assert.assertEquals((Object)plainNotification.getMessageCount(), (Object)payload.customField("unread-messages"));
        Assert.assertEquals((Object)plainNotification.getLastMessageBody(), (Object)payload.customField("body"));
        Assert.assertNull((Object)payload.badge());
        builder = ApnsPayload.newBuilder();
        f = APNsBinaryApiProvider.class.getDeclaredField("staticNotification");
        f.setAccessible(true);
        f.set(provider, true);
        f = APNsBinaryApiProvider.class.getDeclaredField("notificationTitle");
        f.setAccessible(true);
        f.set(provider, "New message!");
        f = APNsBinaryApiProvider.class.getDeclaredField("notificationBody");
        f.setAccessible(true);
        f.set(provider, "There is a new message available!");
        f = APNsBinaryApiProvider.class.getDeclaredField("notificationBadge");
        f.setAccessible(true);
        f.set(provider, 1);
        Assert.assertFalse((boolean)builder.hasBody());
        builder = provider.preparePayload(builder, (INotification)plainNotification, APNsBinaryApiProvider.NotificationType.automatic);
        Assert.assertTrue((boolean)builder.hasBody());
        payload = builder.build();
        Assert.assertNull((Object)payload.customField("account"));
        Assert.assertNull((Object)payload.customField("unread-messages"));
        Assert.assertNull((Object)payload.customField("body"));
        Assert.assertEquals((Object)"New message!", (Object)payload.title());
        Assert.assertEquals((Object)"There is a new message available!", (Object)payload.body());
        Assert.assertEquals((Object)1, (Object)payload.badge());
    }

    @Test
    public void payloadGenerationTest_SendNotificationToFetchOnly() throws TigaseStringprepException, NoSuchFieldException, IllegalAccessException {
        APNsBinaryApiProvider provider = new APNsBinaryApiProvider();
        PlainNotification plainNotification = new PlainNotification(BareJID.bareJIDInstance((String)this.account), INotification.Priority.high, null, null, "New message 123!", null);
        ApnsPayload.Builder builder = ApnsPayload.newBuilder();
        Field f = APNsBinaryApiProvider.class.getDeclaredField("includeAccountInPayload");
        f.setAccessible(true);
        f.set(provider, false);
        f = APNsBinaryApiProvider.class.getDeclaredField("notificationType");
        f.setAccessible(true);
        f.set(provider, APNsBinaryApiProvider.NotificationType.background);
        builder = provider.preparePayload(builder, (INotification)plainNotification, APNsBinaryApiProvider.NotificationType.background);
        Assert.assertFalse((boolean)builder.hasBody());
        ApnsPayload payload = builder.build();
        Assert.assertNull((Object)payload.customField("account"));
        Assert.assertEquals((Object)plainNotification.getMessageCount(), (Object)payload.customField("unread-messages"));
        Assert.assertEquals((Object)plainNotification.getLastMessageBody(), (Object)payload.customField("body"));
        Assert.assertNull((Object)payload.badge());
        builder = ApnsPayload.newBuilder();
        f = APNsBinaryApiProvider.class.getDeclaredField("staticNotification");
        f.setAccessible(true);
        f.set(provider, true);
        f = APNsBinaryApiProvider.class.getDeclaredField("notificationTitle");
        f.setAccessible(true);
        f.set(provider, "New message!");
        f = APNsBinaryApiProvider.class.getDeclaredField("notificationBody");
        f.setAccessible(true);
        f.set(provider, "There is a new message available!");
        f = APNsBinaryApiProvider.class.getDeclaredField("notificationBadge");
        f.setAccessible(true);
        f.set(provider, 1);
        Assert.assertFalse((boolean)builder.hasBody());
        builder = provider.preparePayload(builder, (INotification)plainNotification, APNsBinaryApiProvider.NotificationType.background);
        Assert.assertFalse((boolean)builder.hasBody());
        payload = builder.build();
        Assert.assertNull((Object)payload.customField("account"));
        Assert.assertNull((Object)payload.customField("unread-messages"));
        Assert.assertNull((Object)payload.customField("body"));
        Assert.assertNull((Object)payload.title());
        Assert.assertNull((Object)payload.body());
        Assert.assertNull((Object)payload.badge());
    }

    @Test
    public void payloadGenerationTestAccountRemoved() throws TigaseStringprepException, NoSuchFieldException, IllegalAccessException {
        APNsBinaryApiProvider provider = new APNsBinaryApiProvider();
        PlainNotification plainNotification = new PlainNotification(BareJID.bareJIDInstance((String)this.account), INotification.Priority.high, null, null, null, null, "account-removed", null, null);
        ApnsPayload.Builder builder = ApnsPayload.newBuilder();
        builder = provider.preparePayload(builder, (INotification)plainNotification, APNsBinaryApiProvider.NotificationType.automatic);
        ApnsPayload payload = builder.build();
        Assert.assertEquals((Object)plainNotification.getAccount().toString(), (Object)payload.customField("account"));
        Assert.assertEquals((Object)plainNotification.getMessageCount(), (Object)payload.customField("unread-messages"));
        Assert.assertEquals((Object)plainNotification.getLastMessageBody(), (Object)payload.customField("body"));
        Assert.assertEquals((Object)plainNotification.getEventName(), (Object)payload.customField("event-name"));
        Assert.assertNull((Object)payload.badge());
        builder = ApnsPayload.newBuilder();
        Field f = APNsBinaryApiProvider.class.getDeclaredField("includeAccountInPayload");
        f.setAccessible(true);
        f.set(provider, false);
        builder = provider.preparePayload(builder, (INotification)plainNotification, APNsBinaryApiProvider.NotificationType.automatic);
        payload = builder.build();
        Assert.assertNull((Object)payload.customField("account"));
        Assert.assertEquals((Object)plainNotification.getMessageCount(), (Object)payload.customField("unread-messages"));
        Assert.assertEquals((Object)plainNotification.getLastMessageBody(), (Object)payload.customField("body"));
        Assert.assertNull((Object)payload.badge());
    }
}

