/*
 * Tigase Push - Push notifications component for Tigase
 * Copyright (C) 2017 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.push.repositories;

import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.DataRepositoryPool;

import java.util.Collections;
import java.util.HashMap;

/**
 * Created by andrzej on 05.01.2017.
 */
public class JDBCPushRepositoryTest
		extends AbstractIPushRepositoryTest<DataRepository> {

	private static final String PROJECT_ID = "push";
	private static final String VERSION = "1.0.0";
	@ClassRule
	public static TestRule rule = new TestRule() {
		@Override
		public Statement apply(Statement stmnt, Description d) {
			if (uri == null || !uri.startsWith("jdbc:")) {
				return new Statement() {
					@Override
					public void evaluate() throws Throwable {
						Assume.assumeTrue("Ignored due to not passed DB URI!", false);
					}
				};
			}
			return stmnt;
		}
	};
	// We need at least 2 for SQLServer
	private static int no_of_connections = 1;

	@BeforeClass
	public static void loadSchema() throws DBInitException {
		loadSchema(PROJECT_ID, VERSION, Collections.singleton("push"));
	}

	@Override
	protected DataRepository prepareDataSource()
			throws DBInitException, IllegalAccessException, InstantiationException {
		DataRepositoryPool pool = new DataRepositoryPool();
		pool.initRepository(uri, new HashMap());
		for (int i = 0; i < no_of_connections; i++) {
			pool.addRepo(super.prepareDataSource());
		}
		return pool;
	}

}
