/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.utils.executors;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.config.ConfigField;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.utils.executors.AbstractQueuingExecutor;
import tigase.sys.TigaseRuntime;

@Bean(name="publishExecutor", parent=PubSubComponent.class, active=true, exportable=true)
public class RateLimitingExecutor
extends AbstractQueuingExecutor
implements Runnable,
Initializable {
    private static final Logger log = Logger.getLogger(RateLimitingExecutor.class.getCanonicalName());
    @ConfigField(desc="Limit of tasks executed per second")
    private long limit = Runtime.getRuntime().availableProcessors() * 5000;
    @ConfigField(desc="Limit of amount of used memory that increases throttling")
    private float highMemoryUsageLimit = 90.0f;
    @ConfigField(desc="Limit of amount of used memory that stops publication")
    private float criticalMemoryUsageLimit = 98.0f;
    private Thread executor = null;
    private boolean stopped = false;
    private boolean throttling = false;

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    @Override
    public void run() {
        while (!this.stopped) {
            long actualSleep;
            long start = System.currentTimeMillis();
            long sleepTime = this.getSleepTime();
            MemoryUsage memoryUsage = this.currentMemoryUsage();
            long permissions = this.getPermissions(sleepTime, memoryUsage);
            int i = 0;
            while ((long)i < permissions) {
                try {
                    this.execute();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
            long end = System.currentTimeMillis();
            if (log.isLoggable(Level.CONFIG)) {
                int size = this.queue.totalSize();
                if ((long)size > this.limit || memoryUsage != MemoryUsage.normal) {
                    if (!this.throttling) {
                        log.log(Level.CONFIG, "throttling executions started at rate " + permissions + " every " + sleepTime + "ms, current queue size " + size + ", memory usage " + memoryUsage.name());
                        this.throttling = true;
                    }
                } else {
                    if (this.throttling) {
                        log.log(Level.CONFIG, "throttling executions ended");
                    }
                    this.throttling = false;
                }
            }
            if ((actualSleep = sleepTime - (end - start)) <= 0L) continue;
            try {
                Thread.sleep(actualSleep);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected long getSleepTime() {
        if (this.limit > 10000L) {
            return 1L;
        }
        if (this.limit > 1000L) {
            return 10L;
        }
        if (this.limit > 100L) {
            return 100L;
        }
        return 1000L;
    }

    protected long getPermissions(long sleepTime, MemoryUsage memoryUsage) {
        long permissions = this.limit / (1000L / sleepTime);
        switch (memoryUsage.ordinal()) {
            case 0: {
                return permissions;
            }
            case 1: {
                return (long)Math.ceil((double)permissions * 2.0 / 3.0);
            }
            case 2: {
                return (long)Math.ceil((double)permissions / 3.0);
            }
            case 3: {
                return 0L;
            }
        }
        return permissions;
    }

    public void initialize() {
        if (this.executor != null) {
            return;
        }
        this.executor = new Thread((Runnable)this, "publish-executor");
        this.executor.setDaemon(true);
        this.executor.start();
    }

    @Override
    public void beforeUnregister() {
        this.stopped = true;
        super.beforeUnregister();
        this.executor = null;
    }

    public MemoryUsage currentMemoryUsage() {
        float usage = TigaseRuntime.getTigaseRuntime().getHeapMemUsage();
        if (usage < this.highMemoryUsageLimit) {
            return MemoryUsage.normal;
        }
        if (usage > this.criticalMemoryUsageLimit) {
            return MemoryUsage.critical;
        }
        if (usage > (this.criticalMemoryUsageLimit + this.highMemoryUsageLimit) / 2.0f) {
            return MemoryUsage.veryHigh;
        }
        return MemoryUsage.high;
    }

    public static enum MemoryUsage {
        normal,
        high,
        veryHigh,
        critical;

    }
}

