/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.utils.executors;

import tigase.kernel.beans.UnregisterAware;
import tigase.pubsub.utils.executors.ExecutionQueue;
import tigase.pubsub.utils.executors.Executor;

public class AbstractQueuingExecutor
implements Executor,
UnregisterAware {
    protected final ExecutionQueue queue = new ExecutionQueue();

    @Override
    public boolean isOverloaded() {
        return this.queue.totalSize() > Integer.MAX_VALUE;
    }

    @Override
    public void submit(Executor.Priority priority, Runnable runnable) {
        try {
            this.queue.put(priority, runnable);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeUnregister() {
        ExecutionQueue executionQueue = this.queue;
        synchronized (executionQueue) {
            ((Object)((Object)this.queue)).notifyAll();
        }
    }

    protected void execute() throws InterruptedException {
        Runnable run = (Runnable)this.queue.take();
        if (run != null) {
            run.run();
        }
    }
}

