/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.utils;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Stream;
import tigase.pubsub.utils.Cache;
import tigase.pubsub.utils.LRUCache;
import tigase.stats.StatisticsList;

public class LRUCacheWithFuture<K, V>
implements Cache<K, V> {
    private final LRUCache<K, CompletableFuture<V>> cache;

    public LRUCacheWithFuture() {
        this(2000);
    }

    public LRUCacheWithFuture(int maxSize) {
        this.cache = new LRUCache(maxSize);
    }

    @Override
    public V computeIfAbsent(K key, Cache.CacheSupplier<V> supplier) throws Cache.CacheException {
        CompletableFuture<V> newFuture = new CompletableFuture<V>();
        CompletableFuture oldFuture = this.cache.putIfAbsent(key, newFuture);
        if (oldFuture != null) {
            try {
                return (V)oldFuture.join();
            }
            catch (CancellationException ex) {
                this.cache.remove(key, oldFuture);
                return this.computeIfAbsent(key, supplier);
            }
            catch (CompletionException ex) {
                throw ex;
            }
        }
        try {
            V value = supplier.get();
            newFuture.complete(value);
            if (value == null) {
                this.cache.remove(key, newFuture);
            }
            return (V)newFuture.join();
        }
        catch (CancellationException ex) {
            return this.computeIfAbsent(key, supplier);
        }
        catch (Cache.CacheException ex) {
            newFuture.completeExceptionally(ex);
            this.cache.remove(key);
            throw ex;
        }
    }

    @Override
    public V get(K key) {
        return this.get(key, true);
    }

    private V get(K key, boolean retry) {
        CompletableFuture<V> future = this.cache.get(key);
        if (future == null) {
            return null;
        }
        if (future.isCompletedExceptionally() || future.isCancelled()) {
            this.cache.remove(key);
            return null;
        }
        try {
            return future.join();
        }
        catch (CancellationException ex) {
            return this.get(key, false);
        }
        catch (CompletionException ex) {
            this.cache.remove(key);
            throw ex;
        }
    }

    @Override
    public V put(K key, V value) {
        CompletableFuture<V> node = this.cache.put(key, CompletableFuture.completedFuture(value));
        try {
            if (node != null) {
                node.cancel(true);
            }
            return node == null || node.isCompletedExceptionally() ? null : (V)node.join();
        }
        catch (CancellationException | CompletionException ex) {
            this.cache.remove(key);
            throw ex;
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        CompletableFuture<V> node = this.cache.putIfAbsent(key, CompletableFuture.completedFuture(value));
        try {
            if (node != null) {
                node.cancel(true);
            }
            return node == null || node.isCompletedExceptionally() ? null : (V)node.join();
        }
        catch (CancellationException | CompletionException ex) {
            this.cache.remove(key);
            throw ex;
        }
    }

    @Override
    public V remove(K key) {
        CompletableFuture<V> node = this.cache.remove(key);
        try {
            if (node != null) {
                node.cancel(true);
            }
            return node == null || node.isCompletedExceptionally() ? null : (V)node.join();
        }
        catch (CompletionException ex) {
            this.cache.remove(key);
            throw ex;
        }
    }

    @Override
    public Set<K> keySet() {
        return this.cache.keySet();
    }

    @Override
    public Stream<V> values() {
        return this.cache.values().filter(CompletableFuture::isDone).filter(future -> !future.isCompletedExceptionally()).filter(future -> !future.isCancelled()).map(CompletableFuture::join).filter(Objects::nonNull);
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public void setMaxSize(int size) {
        this.cache.setMaxSize(size);
    }

    public void everyHour() {
        this.cache.everyHour();
    }

    public void everyMinute() {
        this.cache.everyMinute();
    }

    public void everySecond() {
        this.cache.everySecond();
    }

    public void getStatistics(String compName, StatisticsList list) {
        this.cache.getStatistics(compName, list);
    }

    public void setStatisticsPrefix(String prefix) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void statisticExecutedIn(long executionTime) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

