/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.utils;

import java.util.function.IntSupplier;

public final class IntegerOrMax {
    private static final String MAX_STR = "max";
    public static final IntegerOrMax MAX = new IntegerOrMax(0, true);
    private final int value;
    private final boolean isMax;

    public static IntegerOrMax valueOf(String str) {
        if (str == null) {
            return null;
        }
        if (MAX_STR.equals(str)) {
            return MAX;
        }
        return new IntegerOrMax(Integer.parseInt(str), false);
    }

    private IntegerOrMax(int value, boolean isMax) {
        this.value = value;
        this.isMax = isMax;
    }

    public IntegerOrMax(int value) {
        this.value = value;
        this.isMax = false;
    }

    public int getValue() {
        if (this.isMax) {
            throw new NumberFormatException("It is maximal value which cannot be represented as integer.");
        }
        return this.value;
    }

    public boolean isMax() {
        return this.isMax;
    }

    public int getOrMax(int valueForMax) {
        if (this.isMax) {
            return valueForMax;
        }
        return this.value;
    }

    public int getOrMaxGet(IntSupplier valueForMaxSupplier) {
        if (this.isMax) {
            return valueForMaxSupplier.getAsInt();
        }
        return this.value;
    }

    public Integer getOrNull() {
        if (this.isMax) {
            return null;
        }
        return this.value;
    }

    public String toString() {
        if (this.isMax) {
            return MAX_STR;
        }
        return String.valueOf(this.value);
    }
}

