/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.cached.IAffiliationsCached;
import tigase.pubsub.repository.cached.ISubscriptionsCached;
import tigase.xmpp.jid.BareJID;

public class Node<T>
implements INodeMeta<T> {
    private static final Logger log = Logger.getLogger(Node.class.getName());
    private final Date creationTime;
    private final BareJID creator;
    private CopyOnWriteArrayList<String> childNodes;
    private boolean conNeedsWriting = false;
    private boolean deleted = false;
    private String name;
    private IAffiliationsCached nodeAffiliations;
    private AbstractNodeConfig nodeConfig;
    private final T nodeId;
    private ISubscriptionsCached nodeSubscriptions;
    private IItems nodeItems;
    private BareJID serviceJid;

    public Node(T nodeId, BareJID serviceJid, AbstractNodeConfig nodeConfig, IAffiliationsCached nodeAffiliations, ISubscriptionsCached nodeSubscriptions, IItems nodeItems, BareJID creator, Date creationTime) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Constructing Node, serviceJid: {0}, nodeConfig: {1}, nodeId: {2}, nodeAffiliations: {3}, nodeSubscriptions: {4}", new Object[]{serviceJid, nodeConfig, nodeId, nodeAffiliations, nodeSubscriptions});
        }
        this.nodeId = nodeId;
        this.serviceJid = serviceJid;
        this.nodeConfig = nodeConfig;
        this.nodeAffiliations = nodeAffiliations;
        this.nodeSubscriptions = nodeSubscriptions;
        this.name = nodeConfig.getNodeName();
        this.creator = creator;
        this.creationTime = creationTime;
        this.nodeItems = nodeItems;
    }

    protected void affiliationsMerge() {
        this.nodeAffiliations.merge();
    }

    protected boolean affiliationsNeedsWriting() {
        return this.nodeAffiliations.isChanged();
    }

    protected void affiliationsSaved() {
        this.affiliationsMerge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configCopyFrom(AbstractNodeConfig nodeConfig) {
        Node node = this;
        synchronized (node) {
            this.nodeConfig.copyFrom(nodeConfig);
            this.conNeedsWriting = true;
        }
    }

    public boolean configNeedsWriting() {
        return this.conNeedsWriting;
    }

    public void configSaved() {
        this.conNeedsWriting = false;
    }

    public String[] getChildNodes() {
        if (this.childNodes == null) {
            return null;
        }
        return this.childNodes.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChildNodes(List<String> childNodes) {
        Node node = this;
        synchronized (node) {
            if (this.childNodes == null) {
                this.childNodes = new CopyOnWriteArrayList<String>(childNodes);
            } else {
                this.childNodes.addAllAbsent(childNodes);
                this.childNodes.retainAll(childNodes);
            }
        }
    }

    @Override
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Override
    public BareJID getCreator() {
        return this.creator;
    }

    public String getName() {
        return this.name;
    }

    public IAffiliationsCached getNodeAffiliations() {
        return this.nodeAffiliations;
    }

    @Override
    public AbstractNodeConfig getNodeConfig() {
        return this.nodeConfig;
    }

    @Override
    public T getNodeId() {
        return this.nodeId;
    }

    public IItems getNodeItems() {
        return this.nodeItems;
    }

    public ISubscriptionsCached getNodeSubscriptions() {
        return this.nodeSubscriptions;
    }

    public BareJID getServiceJid() {
        return this.serviceJid;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean needsWriting() {
        return this.affiliationsNeedsWriting() || this.subscriptionsNeedsWriting() || this.conNeedsWriting;
    }

    public void resetChanges() {
        this.nodeAffiliations.resetChangedFlag();
        this.nodeSubscriptions.resetChangedFlag();
    }

    public void subscriptionsMerge() {
        this.nodeSubscriptions.merge();
    }

    public boolean subscriptionsNeedsWriting() {
        return this.nodeSubscriptions.isChanged();
    }

    public void subscriptionsSaved() {
        this.subscriptionsMerge();
    }

    public String toString() {
        return "Node{creationTime=" + String.valueOf(this.creationTime) + ", deleted=" + this.deleted + ", name=" + this.name + ", nodeId=" + String.valueOf(this.nodeId) + ", nodeAffiliations=" + String.valueOf(this.nodeAffiliations) + ", nodeSubscriptions=" + String.valueOf(this.nodeSubscriptions) + ", serviceJid=" + String.valueOf(this.serviceJid) + ", creator=" + String.valueOf(this.creator) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childNodeAdded(String childNode) {
        Node node = this;
        synchronized (node) {
            if (this.childNodes == null) {
                return;
            }
            this.childNodes.addIfAbsent(childNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childNodeRemoved(String childNode) {
        Node node = this;
        synchronized (node) {
            if (this.childNodes == null) {
                return;
            }
            this.childNodes.remove(childNode);
        }
    }
}

