/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.pubsub.Affiliation;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.xmpp.jid.BareJID;

public abstract class NodeAffiliations
implements IAffiliations {
    protected static final String DELIMITER = ";";
    private static final Logger LOG = Logger.getLogger(NodeAffiliations.class.getName());
    protected final ConcurrentMap<BareJID, UsersAffiliation> affs = new ConcurrentHashMap<BareJID, UsersAffiliation>(16, 0.9f, 8);

    protected NodeAffiliations() {
    }

    protected NodeAffiliations(Map<BareJID, UsersAffiliation> affs) {
        if (affs != null) {
            this.affs.putAll(affs);
        }
    }

    @Override
    public void addAffiliation(BareJID bareJid, Affiliation affiliation) {
        UsersAffiliation a = new UsersAffiliation(bareJid, affiliation);
        this.affs.put(bareJid, a);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Added affiliation for {0} as {1}", new Object[]{bareJid, a});
        }
    }

    @Override
    public void changeAffiliation(BareJID bareJid, Affiliation affiliation) {
        UsersAffiliation a = this.get(bareJid);
        if (a != null) {
            a.setAffiliation(affiliation);
        } else if (affiliation != Affiliation.none) {
            a = new UsersAffiliation(bareJid, affiliation);
            this.affs.put(bareJid, a);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Changed affiliation for {0} as {1}", new Object[]{bareJid, a});
        }
    }

    @Override
    public UsersAffiliation[] getAffiliations() {
        UsersAffiliation[] a = this.affs.values().toArray(new UsersAffiliation[0]);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Affiliation for node is {0}", new Object[]{Arrays.asList(a)});
        }
        return a;
    }

    public Map<BareJID, UsersAffiliation> getAffiliationsMap() {
        return this.affs;
    }

    @Override
    public UsersAffiliation getSubscriberAffiliation(BareJID bareJid) {
        UsersAffiliation a = this.get(bareJid);
        if (a == null) {
            a = new UsersAffiliation(bareJid, Affiliation.none);
        }
        LOG.log(Level.FINEST, "Affiliation for {0} is {1}", new Object[]{bareJid, a});
        return a;
    }

    @Override
    public int size() {
        return this.affs.size();
    }

    public String toString() {
        return "NodeAffiliations:" + String.valueOf(this.affs);
    }

    protected UsersAffiliation get(BareJID bareJid) {
        UsersAffiliation a = (UsersAffiliation)this.affs.get(bareJid);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Affiliation for {0} is {1}", new Object[]{bareJid, a});
        }
        return a;
    }
}

