/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.mam;

import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.IPubSubConfig;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.mam.PubSubQuery;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.utils.PubSubLogic;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.mam.MAM2ExtendedQueryParser;
import tigase.xmpp.mam.Query;

@Bean(name="mamQueryParser", parent=PubSubComponent.class, active=true)
public class MAMQueryParser
extends MAM2ExtendedQueryParser<PubSubQuery> {
    @Inject
    private IPubSubRepository pubSubRepository;
    @Inject
    private PubSubLogic pubSubLogic;
    @Inject
    private IPubSubConfig pubSubConfig;

    public PubSubQuery parseQuery(PubSubQuery query, Packet packet) throws ComponentException {
        String node = this.parseQueryForNode(packet);
        this.validateNode(packet.getStanzaTo().getBareJID(), node);
        query.setPubsubNode(node);
        super.parseQuery((Query)query, packet);
        return query;
    }

    protected String parseQueryForNode(Packet packet) throws ComponentException {
        return packet.getAttributeStaticStr(Iq.IQ_QUERY_PATH, "node");
    }

    protected void validateNode(BareJID serviceJID, String node) throws PubSubException {
        if (node == null) {
            throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.NODEID_REQUIRED);
        }
        try {
            if (!this.pubSubLogic.isMAMEnabled(serviceJID, node)) {
                throw new PubSubException(Authorization.NOT_ALLOWED);
            }
        }
        catch (RepositoryException ex) {
            throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, ex.getMessage(), (Exception)((Object)ex));
        }
    }
}

