/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.commands;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.exceptions.RepositoryException;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.IPubSubConfig;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.server.AbstractMessageReceiver;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="deleteAllNodesCommand", active=true)
public class DeleteAllNodesCommand
implements AdHocCommand {
    private static final Logger log = Logger.getLogger(DeleteAllNodesCommand.class.getName());
    @Inject(bean="service")
    private AbstractMessageReceiver component;
    @Inject
    private IPubSubConfig config;
    @Inject
    private IPubSubDAO<?, ?, ?> dao;
    @Inject
    private UserRepository userRepo;

    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (data == null) {
                Form form = new Form("result", "Delete all nodes", "To DELETE ALL NODES please check checkbox.");
                form.addField(Field.fieldBoolean((String)"tigase-pubsub#delete-all", (Boolean)Boolean.FALSE, (String)"YES! I'm sure! I want to delete all nodes"));
                response.getElements().add(form.getElement());
                response.startSession();
            } else {
                Form form = new Form(data);
                if ("submit".equals(form.getType())) {
                    Boolean rebuild = form.getAsBoolean("tigase-pubsub#delete-all");
                    if (rebuild != null && rebuild.booleanValue()) {
                        this.startRemoving(request.getIq().getStanzaTo().getBareJID());
                        Form f = new Form(null, "Info", "Nodes has been deleted");
                        response.getElements().add(f.getElement());
                    } else {
                        Form f = new Form(null, "Info", "Deleting cancelled.");
                        response.getElements().add(f.getElement());
                    }
                }
                response.completeSession();
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error processing config command", e);
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public String getName() {
        return "Deleting ALL nodes";
    }

    public String getNode() {
        return "delete-all-nodes";
    }

    public boolean isAllowedFor(JID jid) {
        return Arrays.asList(this.config.getAdmins()).contains(jid.toString());
    }

    private void startRemoving(BareJID serviceJid) throws RepositoryException, UserNotFoundException, TigaseDBException {
        this.dao.deleteService(serviceJid);
        this.userRepo.removeSubnode(this.config.getServiceBareJID(), "nodes");
    }
}

