/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import tigase.kernel.beans.Bean;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.PubSubComponent;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

@Bean(name="xslTransformer", parent=PubSubComponent.class, active=true)
public class XsltTool {
    private final SimpleParser parser = SingletonFactory.getParserInstance();
    private TransformerFactory tFactory = TransformerFactory.newInstance();

    public List<Element> transform(Element item, AbstractNodeConfig nodeConfig) throws TransformerException, IOException {
        StreamSource xsltSource;
        String bodyXsltUrl = nodeConfig.getBodyXslt();
        String bodyXsltEmbedded = nodeConfig.getBodyXsltEmbedded();
        if (bodyXsltEmbedded != null && bodyXsltEmbedded.length() > 1) {
            StringReader reader = new StringReader(bodyXsltEmbedded);
            xsltSource = new StreamSource(reader);
        } else if (bodyXsltUrl != null && bodyXsltUrl.length() > 1) {
            URL x = new URL(bodyXsltUrl);
            xsltSource = new StreamSource(x.openStream());
        } else {
            return null;
        }
        return this.transform(item, xsltSource);
    }

    private List<Element> transform(Element item, Source xslt) throws TransformerException {
        Transformer transformer = this.tFactory.newTransformer(xslt);
        StringReader reader = new StringReader(item.toString());
        StringWriter writer = new StringWriter();
        transformer.transform(new StreamSource(reader), new StreamResult(writer));
        char[] data = writer.toString().toCharArray();
        DomBuilderHandler domHandler = new DomBuilderHandler();
        this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
        Queue q = domHandler.getParsedElements();
        ArrayList<Element> result = new ArrayList<Element>();
        result.addAll(q);
        return result;
    }
}

