/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.logging.Level;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.AccessModel;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.SendLastPublishedItem;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PendingSubscriptionModule;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.utils.PubSubLogic;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="subscribeNodeModule", parent=PubSubComponent.class, active=true)
public class SubscribeNodeModule
extends AbstractPubSubModule {
    private static final Criteria CRIT_SUBSCRIBE = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"subscribe"));
    @Inject
    private PendingSubscriptionModule pendingSubscriptionModule;
    @Inject
    private PublishItemModule publishItemModule;

    private static Affiliation calculateNewOwnerAffiliation(Affiliation ownerAffiliation, Affiliation newAffiliation) {
        if (ownerAffiliation.getWeight() > newAffiliation.getWeight()) {
            return ownerAffiliation;
        }
        return newAffiliation;
    }

    public static Element makeSubscription(String nodeName, BareJID subscriberJid, Subscription newSubscription, String subid) {
        Element resPubSub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
        Element resSubscription = new Element("subscription");
        resPubSub.addChild((XMLNodeIfc)resSubscription);
        resSubscription.setAttribute("node", nodeName);
        resSubscription.setAttribute("jid", subscriberJid.toString());
        resSubscription.setAttribute("subscription", newSubscription.name());
        if (subid != null) {
            resSubscription.setAttribute("subid", subid);
        }
        return resPubSub;
    }

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#manage-subscriptions", "http://jabber.org/protocol/pubsub#auto-subscribe", "http://jabber.org/protocol/pubsub#subscribe", "http://jabber.org/protocol/pubsub#subscription-notifications"};
    }

    public Criteria getModuleCriteria() {
        return CRIT_SUBSCRIBE;
    }

    public void process(Packet packet) throws PubSubException {
        BareJID serviceJid = packet.getStanzaTo().getBareJID();
        Element pubSub = packet.getElement().getChild("pubsub", "http://jabber.org/protocol/pubsub");
        Element subscribe = pubSub.getChild("subscribe");
        JID senderJid = packet.getStanzaFrom();
        String nodeName = subscribe.getAttributeStaticStr("node");
        BareJID jid = BareJID.bareJIDInstanceNS((String)subscribe.getAttributeStaticStr("jid"));
        try {
            AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(serviceJid, nodeName);
            this.pubSubLogic.checkPermission(serviceJid, nodeName, senderJid, PubSubLogic.Action.subscribe);
            IAffiliations nodeAffiliations = this.getRepository().getNodeAffiliations(serviceJid, nodeName);
            UsersAffiliation senderAffiliation = nodeAffiliations.getSubscriberAffiliation(senderJid.getBareJID());
            if (!this.config.isAdmin(senderJid) && senderAffiliation.getAffiliation() != Affiliation.owner && !jid.equals((Object)senderJid.getBareJID())) {
                throw new PubSubException(packet.getElement(), Authorization.BAD_REQUEST, PubSubErrorCondition.INVALID_JID);
            }
            ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(serviceJid, nodeName);
            AccessModel accessModel = nodeConfig.getNodeAccessModel();
            ArrayList<Packet> results = new ArrayList<Packet>();
            Subscription newSubscription = Subscription.none;
            Affiliation affiliation = nodeAffiliations.getSubscriberAffiliation(jid).getAffiliation();
            if (this.config.isAdmin(senderJid) || senderAffiliation.getAffiliation() == Affiliation.owner) {
                newSubscription = Subscription.subscribed;
                affiliation = SubscribeNodeModule.calculateNewOwnerAffiliation(affiliation, Affiliation.member);
            } else {
                switch (accessModel) {
                    case open: 
                    case presence: 
                    case roster: 
                    case whitelist: {
                        newSubscription = Subscription.subscribed;
                        affiliation = SubscribeNodeModule.calculateNewOwnerAffiliation(affiliation, Affiliation.member);
                        break;
                    }
                    case authorize: {
                        newSubscription = Subscription.pending;
                        affiliation = SubscribeNodeModule.calculateNewOwnerAffiliation(affiliation, Affiliation.none);
                    }
                }
            }
            String subid = nodeSubscriptions.getSubscriptionId(jid);
            boolean sendLastPublishedItem = false;
            if (subid == null) {
                subid = nodeSubscriptions.addSubscriberJid(jid, newSubscription);
                nodeAffiliations.addAffiliation(jid, affiliation);
                if (accessModel == AccessModel.authorize && !this.config.isAdmin(senderJid) && senderAffiliation.getAffiliation() != Affiliation.owner) {
                    results.addAll(this.pendingSubscriptionModule.sendAuthorizationRequest(nodeName, packet.getStanzaTo(), subid, jid, nodeAffiliations));
                }
                sendLastPublishedItem = nodeConfig.getSendLastPublishedItem() == SendLastPublishedItem.on_sub || nodeConfig.getSendLastPublishedItem() == SendLastPublishedItem.on_sub_and_presence;
            } else {
                nodeSubscriptions.changeSubscription(jid, newSubscription);
                nodeAffiliations.changeAffiliation(jid, affiliation);
            }
            this.getRepository().update(serviceJid, nodeName, nodeSubscriptions);
            this.getRepository().update(serviceJid, nodeName, nodeAffiliations);
            Packet result = packet.okResult(SubscribeNodeModule.makeSubscription(nodeName, jid, newSubscription, subid), 0);
            results.add(result);
            this.packetWriter.write(results);
            if (sendLastPublishedItem) {
                this.publishItemModule.publishLastItem(serviceJid, nodeConfig, JID.jidInstance((BareJID)jid));
            }
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error processing subscribe node packet", e);
            throw new RuntimeException(e);
        }
    }
}

