/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.CapsModule;
import tigase.pubsub.repository.PresenceCollectorRepository;
import tigase.server.Packet;
import tigase.server.Presence;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.impl.PresenceCapabilitiesManager;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="presenceCollectorModule", parent=PubSubComponent.class, active=true)
public class PresenceCollectorModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"presence");
    @Inject
    private CapsModule capsModule;
    @Inject
    private EventBus eventBus;
    @Inject
    private PresenceCollectorRepository presenceByService;

    public boolean addJid(BareJID serviceJid, JID jid, String caps) {
        if (jid == null) {
            return false;
        }
        boolean wasAvailable = this.presenceByService.isAvailable(serviceJid, jid);
        String oldCaps = this.presenceByService.add(serviceJid, jid, caps);
        boolean added = oldCaps == null && !wasAvailable;
        log.finest("for service " + String.valueOf(serviceJid) + " - Contact " + String.valueOf(jid) + " is collected.");
        if (this.config.isPepPeristent() && this.config.isSendLastPublishedItemOnPresence() && (serviceJid.getLocalpart() != null || this.config.isSubscribeByPresenceFilteredNotifications()) && oldCaps != caps && caps != null) {
            Set<String> newFeatures = Collections.emptySet();
            if (!Objects.equals(oldCaps, caps) && caps != null) {
                String[] oldFeatures;
                String[] features = caps != null ? PresenceCapabilitiesManager.getNodeFeatures((String)caps) : null;
                String[] stringArray = oldFeatures = oldCaps != null ? PresenceCapabilitiesManager.getNodeFeatures((String)oldCaps) : null;
                if (features != null) {
                    Stream<String> featuresStream = Arrays.stream(features);
                    if (oldFeatures != null) {
                        featuresStream = featuresStream.filter(f -> Arrays.binarySearch(oldFeatures, f) < 0);
                    }
                    newFeatures = featuresStream.collect(Collectors.toSet());
                }
            }
            if (!newFeatures.isEmpty()) {
                this.fireCapsChangeEvent(serviceJid, jid, caps, oldCaps, newFeatures);
            }
        }
        return added;
    }

    @Override
    public boolean canHandle(Packet packet) {
        if (packet.getStanzaTo() == null || packet.getStanzaTo().getResource() != null) {
            return false;
        }
        return super.canHandle(packet);
    }

    public List<JID> getAllAvailableJids(BareJID serviceJid) {
        return this.presenceByService.getAllAvailableJids(serviceJid, x -> true).filter(this::isAvailableLocally).collect(Collectors.toList());
    }

    public List<JID> getAllAvailableJidsWithFeature(BareJID serviceJid, String feature) {
        Set nodesWithFeature = PresenceCapabilitiesManager.getNodesWithFeature((String)feature);
        return this.presenceByService.getAllAvailableJids(serviceJid, nodesWithFeature::contains).collect(Collectors.toList());
    }

    public List<JID> getAllAvailableResources(BareJID serviceJid, BareJID bareJid) {
        return this.presenceByService.getAllAvailableResources(serviceJid, bareJid).stream().filter(this::isAvailableLocally).collect(Collectors.toList());
    }

    public String[] getFeatures() {
        if (this.config.isSubscribeByPresenceFilteredNotifications()) {
            return new String[]{"http://jabber.org/protocol/pubsub#presence-notifications", "http://jabber.org/protocol/pubsub#filtered-notifications"};
        }
        return new String[]{"http://jabber.org/protocol/pubsub#presence-notifications"};
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public boolean isJidAvailable(BareJID serviceJid, BareJID bareJid) {
        return this.presenceByService.isAvailable(serviceJid, bareJid);
    }

    public void process(Packet packet) throws PubSubException {
        StanzaType type = packet.getType();
        JID jid = packet.getStanzaFrom();
        JID toJid = packet.getStanzaTo();
        if (jid == null || toJid == null) {
            return;
        }
        if (type == null || type == StanzaType.available) {
            String[] caps = this.config.isPepPeristent() ? this.capsModule.processPresence(packet) : null;
            boolean added = this.addJid(toJid.getBareJID(), jid, caps == null || caps.length == 0 ? null : caps[0]);
            if (added) {
                this.firePresenceChangeEvent(packet);
            }
            if (added && packet.getStanzaTo().getLocalpart() == null) {
                Presence p = new Presence(new Element("presence", new String[]{"to", "from", "xmlns"}, new String[]{jid.toString(), toJid.toString(), "jabber:client"}), toJid, jid);
                this.packetWriter.write((Packet)p);
            }
        } else if (StanzaType.unavailable == type) {
            boolean removed = this.removeJid(toJid.getBareJID(), jid);
            if (removed) {
                this.firePresenceChangeEvent(packet);
            }
            if (packet.getStanzaTo().getLocalpart() == null) {
                Presence p = new Presence(new Element("presence", new String[]{"to", "from", "type", "xmlns"}, new String[]{jid.toString(), toJid.toString(), StanzaType.unavailable.toString(), "jabber:client"}), toJid, jid);
                this.packetWriter.write((Packet)p);
            }
        } else if (StanzaType.subscribe == type) {
            log.finest("Contact " + String.valueOf(jid) + " wants to subscribe PubSub");
            Packet presence = this.preparePresence(packet, StanzaType.subscribed);
            if (presence != null) {
                this.packetWriter.write(presence);
            }
            if ((presence = this.preparePresence(packet, StanzaType.subscribe)) != null) {
                this.packetWriter.write(presence);
            }
        } else if (StanzaType.unsubscribe == type || StanzaType.unsubscribed == type) {
            log.finest("Contact " + String.valueOf(jid) + " wants to unsubscribe PubSub");
            Packet presence = this.preparePresence(packet, StanzaType.unsubscribed);
            if (presence != null) {
                this.packetWriter.write(presence);
            }
            if ((presence = this.preparePresence(packet, StanzaType.unsubscribe)) != null) {
                this.packetWriter.write(presence);
            }
        }
    }

    protected boolean isAvailableLocally(JID jid) {
        return true;
    }

    protected boolean removeJid(BareJID serviceJid, JID jid) {
        if (jid == null) {
            return false;
        }
        boolean removed = this.presenceByService.remove(serviceJid, jid);
        return removed;
    }

    private void fireCapsChangeEvent(BareJID serviceJid, JID jid, String caps, String oldCaps, Set<String> newFeatures) {
        this.eventBus.fire((Object)new CapsChangeEvent(this.config.getComponentName(), serviceJid, jid, caps, oldCaps, newFeatures));
    }

    private void firePresenceChangeEvent(Packet packet) {
        this.eventBus.fire((Object)new PresenceChangeEvent(this.config.getComponentName(), packet));
    }

    private Packet preparePresence(Packet presence, StanzaType type) {
        JID to = presence.getTo();
        JID from = presence.getStanzaFrom();
        if (from != null && to != null && !from.getBareJID().equals((Object)to.getBareJID())) {
            JID jid = from.copyWithoutResource();
            Element p = new Element("presence", new String[]{"to", "from", "xmlns"}, new String[]{jid.toString(), to.toString(), "jabber:client"});
            if (type != null) {
                p.setAttribute("type", type.toString());
            }
            return new Presence(p, to, from);
        }
        return null;
    }

    public static class CapsChangeEvent {
        public final String componentName;
        public final JID buddyJid;
        public final String newCaps;
        public final Set<String> newFeatures;
        public final String oldCaps;
        public final BareJID serviceJid;

        public CapsChangeEvent(String componentName, BareJID serviceJid, JID buddyJid, String newCaps, String oldCaps, Set<String> newFeatures) {
            this.componentName = componentName;
            this.serviceJid = serviceJid;
            this.buddyJid = buddyJid;
            this.newCaps = newCaps;
            this.oldCaps = oldCaps;
            this.newFeatures = newFeatures;
        }
    }

    public static class PresenceChangeEvent {
        public final Packet packet;
        public final String componentName;

        public PresenceChangeEvent(String componentName, Packet packet) {
            this.componentName = componentName;
            this.packet = packet;
        }
    }
}

