/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@Bean(name="item-validator", parent=PubSubComponent.class, active=false)
public class ItemValidator
implements IPubSubRepository.IListener {
    private static final String OMEMO_BUNDLES_NODE_PREFIX = "eu.siacs.conversations.axolotl.bundles:";
    @Inject
    private CachedPubSubRepository cachedPubSubRepository;
    @ConfigField(desc="Max no. of OMEMO identities", alias="omemo-identities-limit")
    private Integer omemoIdentitiesLimit = null;
    @ConfigField(desc="Enforce unchangeable OMEMO device identity key", alias="omemo-unique-device-identity")
    private boolean omemoUniqueDeviceIdentity = false;

    @Override
    public void itemWritten(BareJID serviceJID, String node, String id, String publisher, Element item, String uuid) {
    }

    @Override
    public void itemDeleted(BareJID serviceJID, String node, String id) {
    }

    @Override
    public boolean validateItem(BareJID serviceJID, String node, String id, String publisher, Element item) throws PubSubException {
        if (serviceJID.getLocalpart() != null && node != null && node.startsWith(OMEMO_BUNDLES_NODE_PREFIX)) {
            if (this.omemoIdentitiesLimit != null) {
                try {
                    long otherIdentities = Optional.ofNullable(this.cachedPubSubRepository.getRootCollection(serviceJID)).stream().flatMap(Arrays::stream).filter(nodeName -> nodeName.startsWith(OMEMO_BUNDLES_NODE_PREFIX) && !nodeName.equals(node)).count();
                    if (otherIdentities + 1L > (long)this.omemoIdentitiesLimit.intValue()) {
                        throw new PubSubException(Authorization.POLICY_VIOLATION, "Exceeded OMEMO bundles limit!");
                    }
                }
                catch (RepositoryException ex) {
                    throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, "It was not possible to validate the item", (Exception)((Object)ex));
                }
            }
            if (this.omemoUniqueDeviceIdentity) {
                try {
                    String newIdentityKey;
                    String prevIdentityKey = this.extractIdentityKey(this.getNodeItem(serviceJID, node, "current"));
                    if (prevIdentityKey != null && !Objects.equals(prevIdentityKey, newIdentityKey = this.extractIdentityKey(item))) {
                        throw new PubSubException(Authorization.POLICY_VIOLATION, "New OMEMO bundle changes identity key!");
                    }
                }
                catch (RepositoryException ex) {
                    throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, "It was not possible to validate the item", (Exception)((Object)ex));
                }
            }
        }
        return true;
    }

    @Override
    public void serviceRemoved(BareJID serviceJID) {
    }

    protected Element getNodeItem(BareJID serviceJID, String node, String itemId) throws RepositoryException {
        IItems items = this.cachedPubSubRepository.getNodeItems(serviceJID, node);
        if (items == null) {
            return null;
        }
        IItems.IItem prevItem = items.getItem("current");
        if (prevItem == null) {
            return null;
        }
        return prevItem.getItem();
    }

    protected String extractIdentityKey(Element item) {
        if (item == null) {
            return null;
        }
        Element bundleEL = item.getChild("bundle", "eu.siacs.conversations.axolotl");
        if (bundleEL == null) {
            return null;
        }
        Element identityKey = bundleEL.getChild("identityKey");
        if (identityKey == null) {
            return null;
        }
        return identityKey.getCData();
    }
}

