/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.converter;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import tigase.db.DataRepository;
import tigase.db.converter.Converter;

class PubSubQueries {
    static final String NODES = "SELECT host, node, parent, nodeid, ( SELECT COUNT(*) FROM `pubsub_node` WHERE pubsub_node.host = outer_pubsub_node.host AND `node` like CONCAT(outer_pubsub_node.node, '/%')) AS counter FROM pubsub_node as outer_pubsub_node order by host, counter DESC, node";
    static final String NODES_MSSQL = "SELECT host, node, parent, nodeid, ( SELECT COUNT(*) FROM [pubsub_node] WHERE pubsub_node.host = outer_pubsub_node.host AND [node] like CONCAT(outer_pubsub_node.node, '/%')) AS counter FROM pubsub_node as outer_pubsub_node order by host, counter DESC, node";
    static final String NODE_OPTIONS = "SELECT name, val FROM pubsub_node_option WHERE nodeid = ?";
    static final String NODE_OWNER = "SELECT owner FROM pubsub_node_owner where nodeid = ?";
    static final String SUBSCRIPTIONS = "SELECT jid, affiliation, subscriptions, stateid FROM pubsub_state WHERE nodeid = ?";
    static final String SUBSCRIPTION_OPT = "SELECT subid, opt_name, opt_value FROM pubsub_subscription_opt";
    static final String ITEMS = "SELECT pubsub_item.nodeid, host, node, itemid, publisher, creation, modification, payload FROM pubsub_item LEFT JOIN pubsub_node on pubsub_item.nodeid = pubsub_node.nodeid order by host, node, creation";
    final Map<String, String> selectedQueries;
    DataRepository.dbTypes dbType;
    Map<String, Map<String, Map<String, String>>> queries = new ConcurrentHashMap<String, Map<String, Map<String, String>>>();
    Converter.SERVER serverType;

    PubSubQueries(Converter.SERVER serverType, DataRepository.dbTypes dbType) {
        this.serverType = serverType;
        this.dbType = dbType;
        Map ejabberdQueries = this.queries.computeIfAbsent(Converter.SERVER.ejabberd.name(), k -> new ConcurrentHashMap());
        ConcurrentHashMap<String, String> ejabberdSqlGeneric = new ConcurrentHashMap<String, String>();
        ejabberdSqlGeneric.put(ITEMS, ITEMS);
        ejabberdSqlGeneric.put(NODES, NODES);
        ejabberdSqlGeneric.put(NODE_OPTIONS, NODE_OPTIONS);
        ejabberdSqlGeneric.put(NODE_OWNER, NODE_OWNER);
        ejabberdSqlGeneric.put(SUBSCRIPTIONS, SUBSCRIPTIONS);
        ejabberdSqlGeneric.put(SUBSCRIPTION_OPT, SUBSCRIPTION_OPT);
        ConcurrentHashMap<String, String> ejabberdMssql = new ConcurrentHashMap<String, String>(ejabberdSqlGeneric);
        ejabberdMssql.put(NODES, NODES_MSSQL);
        ejabberdQueries.put(DataRepository.dbTypes.sqlserver.name(), ejabberdMssql);
        ejabberdQueries.put(DataRepository.dbTypes.jtds.name(), ejabberdMssql);
        ejabberdQueries.put(DataRepository.dbTypes.mysql.name(), ejabberdSqlGeneric);
        ejabberdQueries.put(DataRepository.dbTypes.postgresql.name(), ejabberdSqlGeneric);
        this.selectedQueries = this.getAllQueriesForServerAndDatabase().orElse(Collections.emptyMap());
    }

    Optional<String> getQuery(String query) {
        return Optional.ofNullable(this.selectedQueries.get(query));
    }

    Optional<Map<String, String>> getAllQueriesForServerAndDatabase() {
        Map orDefault = this.queries.getOrDefault(this.serverType.name(), Collections.emptyMap());
        Map value = (Map)orDefault.get(this.dbType.name());
        return Optional.ofNullable(value);
    }
}

