/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.pubsub.Affiliation;
import tigase.pubsub.repository.cached.IAffiliationsCached;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.xmpp.jid.BareJID;

public class NodeAffiliations
extends tigase.pubsub.repository.NodeAffiliations
implements IAffiliationsCached {
    private static final Logger log = Logger.getLogger(NodeAffiliations.class.getName());
    protected final ThreadLocal<Map<BareJID, UsersAffiliation>> changedAffs = new ThreadLocal();

    public NodeAffiliations() {
    }

    public NodeAffiliations(Map<BareJID, UsersAffiliation> affs) {
        super(affs);
    }

    @Override
    public void addAffiliation(BareJID bareJid, Affiliation affiliation) {
        UsersAffiliation a = new UsersAffiliation(bareJid, affiliation);
        this.changedAffs().put(bareJid, a);
    }

    @Override
    public void changeAffiliation(BareJID bareJid, Affiliation affiliation) {
        UsersAffiliation a = this.get(bareJid);
        Map<BareJID, UsersAffiliation> changedAffs = this.changedAffs();
        if (a != null) {
            a.setAffiliation(affiliation);
            changedAffs.put(bareJid, a);
        } else if (affiliation != Affiliation.none) {
            a = new UsersAffiliation(bareJid, affiliation);
            changedAffs.put(bareJid, a);
        }
    }

    public NodeAffiliations clone() throws CloneNotSupportedException {
        NodeAffiliations clone = new NodeAffiliations();
        for (UsersAffiliation a : this.affs.values()) {
            clone.affs.put(a.getJid(), a.clone());
        }
        Map<BareJID, UsersAffiliation> changedAffs = this.changedAffs();
        Map<BareJID, UsersAffiliation> cloneChangedAffs = clone.changedAffs();
        for (UsersAffiliation a : changedAffs.values()) {
            cloneChangedAffs.put(a.getJid(), a.clone());
        }
        return clone;
    }

    @Override
    public UsersAffiliation[] getAffiliations() {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.affs.values());
        result.addAll(this.changedAffs().values());
        return result.toArray(new UsersAffiliation[0]);
    }

    @Override
    public Map<BareJID, UsersAffiliation> getChanged() {
        return Collections.unmodifiableMap(this.changedAffs());
    }

    @Override
    public boolean isChanged() {
        return this.changedAffs().size() > 0;
    }

    @Override
    public void merge() {
        Map<BareJID, UsersAffiliation> changedAffs = this.changedAffs();
        for (Map.Entry<BareJID, UsersAffiliation> entry : changedAffs.entrySet()) {
            if (entry.getValue().getAffiliation() == Affiliation.none) {
                this.affs.remove(entry.getKey());
                continue;
            }
            this.affs.put(entry.getKey(), entry.getValue());
        }
        changedAffs.clear();
    }

    @Override
    public void resetChangedFlag() {
        this.changedAffs().clear();
    }

    @Override
    protected UsersAffiliation get(BareJID bareJid) {
        Map<BareJID, UsersAffiliation> changedAffs = this.changedAffs();
        UsersAffiliation us = changedAffs.get(bareJid);
        if (us == null && (us = (UsersAffiliation)this.affs.get(bareJid)) != null) {
            try {
                return us.clone();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Cloning failed", e);
                return null;
            }
        }
        return us;
    }

    private Map<BareJID, UsersAffiliation> changedAffs() {
        Map<BareJID, UsersAffiliation> changedAffs = this.changedAffs.get();
        if (changedAffs == null) {
            changedAffs = new HashMap<BareJID, UsersAffiliation>();
            this.changedAffs.set(changedAffs);
        }
        return changedAffs;
    }
}

