/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

public class Items<T>
implements IItems {
    private static final Logger log = Logger.getLogger(Items.class.getName());
    private final IPubSubDAO<T, ?, ?> dao;
    private final T nodeId;
    private final String nodeName;
    private final BareJID serviceJid;
    private final IItems.IListnener itemsListener;

    public Items(T nodeId, BareJID serviceJid, String nodeName, IPubSubDAO dao, IItems.IListnener listnener) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Constructing Items, serviceJid: {0}, nodeName: {1}, nodeId: {2}, dao: {3}", new Object[]{serviceJid, nodeName, nodeId, dao});
        }
        this.nodeId = nodeId;
        this.dao = dao;
        this.nodeName = nodeName;
        this.serviceJid = serviceJid;
        this.itemsListener = listnener;
    }

    @Override
    public void deleteItem(String id) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Deleting item, serviceJid: {0}, id: {1}, nodeId: {2}, dao: {3}", new Object[]{this.serviceJid, id, this.nodeId, this.dao});
        }
        this.dao.deleteItem(this.serviceJid, this.nodeId, id);
        this.itemsListener.itemDeleted(this.serviceJid, this.nodeName, id);
    }

    @Override
    public IItems.IItem getItem(String id) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "getItem, serviceJid: {0}, id: {1}, nodeId: {2}, dao: {3}", new Object[]{this.serviceJid, id, this.nodeId, this.dao});
        }
        return this.dao.getItem(this.serviceJid, this.nodeId, id);
    }

    @Override
    public String[] getItemsIds(CollectionItemsOrdering order) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "getItemsIds, serviceJid: {0}, nodeId: {1}, dao: {2}, order: {3}", new Object[]{this.serviceJid, this.nodeId, this.dao, order});
        }
        return this.dao.getItemsIds(this.serviceJid, this.nodeId, order);
    }

    @Override
    public String[] getItemsIdsSince(CollectionItemsOrdering order, Date since) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "getItemsIdsSince, serviceJid: {0}, nodeId: {1}, dao: {2}, order: {3}, since: {4}", new Object[]{this.serviceJid, this.nodeId, this.dao, order, since});
        }
        return this.dao.getItemsIdsSince(this.serviceJid, this.nodeId, order, since);
    }

    @Override
    public List<IItems.ItemMeta> getItemsMeta() throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "getItemsIdsSince, serviceJid: {0}, nodeId: {1}, dao: {2}", new Object[]{this.serviceJid, this.nodeId, this.dao});
        }
        return this.dao.getItemsMeta(this.serviceJid, this.nodeId, this.nodeName);
    }

    @Override
    public IItems.IItem getLastItem(CollectionItemsOrdering order) throws RepositoryException {
        String[] itemIds = this.getItemsIds(order);
        if (itemIds != null && itemIds.length > 0) {
            return this.getItem(itemIds[itemIds.length - 1]);
        }
        return null;
    }

    @Override
    public void writeItem(String id, String publisher, Element item, String uuid) throws RepositoryException, PubSubException {
        if (this.itemsListener.validateItem(this.serviceJid, this.nodeName, id, publisher, item)) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "writeItem, serviceJid: {0}, nodeId: {1}, dao: {2}, id: {3}, publisher: {4}, item: {5}", new Object[]{this.serviceJid, this.nodeId, this.dao, id, publisher, item});
            }
        } else {
            throw new PubSubException(Authorization.FORBIDDEN, "Provided item did not pass validation");
        }
        this.dao.writeItem(this.serviceJid, this.nodeId, System.currentTimeMillis(), id, publisher, item, uuid);
        this.itemsListener.itemWritten(this.serviceJid, this.nodeName, id, publisher, item, uuid);
    }
}

