/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataSource;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.form.Form;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.modules.mam.PubSubQuery;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.impl.roster.RosterFlat;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.util.MAMUtil;
import tigase.xmpp.mam.util.Range;
import tigase.xmpp.rsm.RSM;

public abstract class PubSubDAO<T, S extends DataSource, Q extends PubSubQuery>
implements IPubSubDAO<T, S, Q> {
    protected static final Logger log = Logger.getLogger(PubSubDAO.class.getCanonicalName());
    private final SimpleParser parser = SingletonFactory.getParserInstance();
    @Inject
    private UserRepository repository;

    protected static void calculateOffsetAndPosition(RSM rsm, int count, Integer before, Integer after) {
        MAMUtil.calculateOffsetAndPosition((RSM)rsm, (int)count, (Integer)before, (Integer)after, (Range)Range.FULL);
    }

    protected PubSubDAO() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public Map<BareJID, RosterElement> getUserRoster(BareJID owner) throws RepositoryException {
        try {
            String tmp = this.repository.getData(owner, "roster");
            HashMap<BareJID, RosterElement> roster = new HashMap<BareJID, RosterElement>();
            if (tmp != null) {
                RosterFlat.parseRosterUtil((String)tmp, roster, null);
            }
            return roster;
        }
        catch (UserNotFoundException ex) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Cannot find roster of user {0}. Probably anonymous user.", new Object[]{owner});
            }
            return Collections.emptyMap();
        }
        catch (Exception e) {
            throw new RepositoryException("Getting user roster error", (Throwable)e);
        }
    }

    @Override
    public AbstractNodeConfig parseConfig(String nodeName, String data) throws RepositoryException {
        try {
            Form cnfForm = this.parseConfigForm(data);
            if (cnfForm == null) {
                return null;
            }
            NodeType type = NodeType.valueOf(cnfForm.getAsString("pubsub#node_type"));
            Class cl = null;
            switch (type) {
                case collection: {
                    cl = CollectionNodeConfig.class;
                    break;
                }
                case leaf: {
                    cl = LeafNodeConfig.class;
                    break;
                }
                default: {
                    throw new RepositoryException("Unknown node type " + String.valueOf((Object)type));
                }
            }
            CollectionNodeConfig nc = this.getNodeConfig(cl, nodeName, cnfForm);
            return nc;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException("Node configuration reading error", (Throwable)e);
        }
    }

    protected <T extends AbstractNodeConfig> T getNodeConfig(Class<T> nodeConfigClass, String nodeName, Form configForm) throws RepositoryException {
        try {
            Constructor<T> constructor = nodeConfigClass.getConstructor(String.class);
            AbstractNodeConfig nodeConfig = (AbstractNodeConfig)constructor.newInstance(nodeName);
            nodeConfig.copyFromForm(configForm);
            return (T)nodeConfig;
        }
        catch (Exception e) {
            throw new RepositoryException("Node configuration reading error", (Throwable)e);
        }
    }

    protected Element itemDataToElement(String data) {
        if (data == null) {
            return null;
        }
        return this.itemDataToElement(data.toCharArray());
    }

    protected Element itemDataToElement(char[] data) {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
        Queue q = domHandler.getParsedElements();
        return (Element)q.element();
    }

    protected Form parseConfigForm(String cnfData) {
        if (cnfData == null) {
            return null;
        }
        char[] data = cnfData.toCharArray();
        DomBuilderHandler domHandler = new DomBuilderHandler();
        this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
        Queue q = domHandler.getParsedElements();
        if (q != null && q.size() > 0) {
            Form form = new Form((Element)q.element());
            return form;
        }
        return null;
    }

    public static class MAMItem
    implements MAMRepository.Item {
        private final String itemUuid;
        private final Date ts;
        private final Element message;

        public MAMItem(String itemUuid, Date ts, Element message) {
            this.itemUuid = itemUuid.toLowerCase();
            this.ts = ts;
            this.message = message;
        }

        public String getId() {
            return this.itemUuid;
        }

        public Element getMessage() {
            return this.message;
        }

        public Date getTimestamp() {
            return this.ts;
        }
    }
}

