/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.xmpp.jid.BareJID;

public abstract class NodeSubscriptions
implements ISubscriptions {
    protected static final String DELIMITER = ";";
    protected static final Logger log = Logger.getLogger(NodeSubscriptions.class.getName());
    protected final ConcurrentMap<BareJID, UsersSubscription> subs = new ConcurrentHashMap<BareJID, UsersSubscription>();

    public static tigase.pubsub.repository.cached.NodeSubscriptions create() {
        tigase.pubsub.repository.cached.NodeSubscriptions s = new tigase.pubsub.repository.cached.NodeSubscriptions();
        return s;
    }

    protected NodeSubscriptions() {
    }

    protected NodeSubscriptions(Map<BareJID, UsersSubscription> subscriptions) {
        if (subscriptions != null) {
            this.subs.putAll(subscriptions);
        }
    }

    @Override
    public String addSubscriberJid(BareJID bareJid, Subscription subscription) {
        String subid = Utils.createUID(bareJid);
        UsersSubscription s = new UsersSubscription(bareJid, subid, subscription);
        this.subs.put(bareJid, s);
        return subid;
    }

    @Override
    public void changeSubscription(BareJID bareJid, Subscription subscription) {
        UsersSubscription s = this.get(bareJid);
        if (s != null) {
            s.setSubscription(subscription);
        }
    }

    @Override
    public Subscription getSubscription(BareJID bareJid) {
        UsersSubscription s = this.get(bareJid);
        if (s != null) {
            return s.getSubscription();
        }
        return Subscription.none;
    }

    @Override
    public String getSubscriptionId(BareJID bareJid) {
        UsersSubscription s = this.get(bareJid);
        if (s != null) {
            return s.getSubid();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<UsersSubscription> getSubscriptions() {
        ConcurrentMap<BareJID, UsersSubscription> concurrentMap = this.subs;
        synchronized (concurrentMap) {
            return this.subs.values().stream();
        }
    }

    @Override
    public Stream<UsersSubscription> getSubscriptionsForPublish() {
        return this.getSubscriptions();
    }

    public void init(Queue<UsersSubscription> data) {
        UsersSubscription s = null;
        while ((s = data.poll()) != null) {
            this.subs.put(s.getJid(), s);
        }
    }

    @Override
    public int size() {
        return this.subs.size();
    }

    public String toString() {
        return "NodeSubscriptions: " + String.valueOf(this.subs);
    }

    protected UsersSubscription get(BareJID bareJid) {
        return (UsersSubscription)this.subs.get(bareJid);
    }
}

