/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.ext.presence;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import tigase.pubsub.Subscription;
import tigase.pubsub.modules.ext.presence.PresencePerNodeExtension;
import tigase.pubsub.repository.cached.ISubscriptionsCached;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.server.Packet;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class PresenceNodeSubscriptions
implements ISubscriptionsCached {
    private final PresencePerNodeExtension extension;
    private final String nodeName;
    private final BareJID serviceJID;
    private final ISubscriptionsCached subscriptions;

    public PresenceNodeSubscriptions(BareJID serviceJid, String nodeName, ISubscriptionsCached subscriptions, PresencePerNodeExtension extension) {
        this.serviceJID = serviceJid;
        this.nodeName = nodeName;
        this.subscriptions = subscriptions;
        this.extension = extension;
    }

    @Override
    public String addSubscriberJid(BareJID jid, Subscription subscription) {
        return this.subscriptions.addSubscriberJid(jid, subscription);
    }

    @Override
    public void changeSubscription(BareJID jid, Subscription subscription) {
        this.subscriptions.changeSubscription(jid, subscription);
    }

    @Override
    public Subscription getSubscription(BareJID jid) {
        Subscription s = this.subscriptions.getSubscription(jid);
        if (s == Subscription.none) {
            Collection<Packet> ocs = this.extension.getPresence(this.serviceJID, this.nodeName, jid);
            for (Packet packet : ocs) {
                if (packet.getType() != null && packet.getType() != StanzaType.available) continue;
                return Subscription.subscribed;
            }
        }
        return s;
    }

    @Override
    public String getSubscriptionId(BareJID jid) {
        String id = this.subscriptions.getSubscriptionId(jid);
        if (id == null) {
            Collection<Packet> ocs = this.extension.getPresence(this.serviceJID, this.nodeName, jid);
            for (Packet packet : ocs) {
                if (packet.getType() != null && packet.getType() != StanzaType.available) continue;
                return "pr:" + packet.getStanzaFrom().getBareJID().hashCode();
            }
        }
        return id;
    }

    @Override
    public Stream<UsersSubscription> getSubscriptions() {
        HashMap<BareJID, UsersSubscription> result = new HashMap<BareJID, UsersSubscription>();
        this.subscriptions.getSubscriptions().forEach(usersSubscription -> result.put(usersSubscription.getJid(), (UsersSubscription)usersSubscription));
        Collection<JID> occupants = this.extension.getNodeOccupants(this.serviceJID, this.nodeName);
        for (JID jid : occupants) {
            Packet pr;
            if (result.containsKey(jid.getBareJID()) || (pr = this.extension.getPresence(this.serviceJID, this.nodeName, jid)).getType() != null && pr.getType() != StanzaType.available) continue;
            result.put(jid.getBareJID(), new UsersSubscription(jid.getBareJID(), "pr:" + jid.getBareJID().hashCode(), Subscription.subscribed));
        }
        return result.values().stream();
    }

    @Override
    public Stream<UsersSubscription> getSubscriptionsForPublish() {
        return this.getSubscriptions();
    }

    @Override
    public int size() {
        return this.subscriptions.size();
    }

    @Override
    public void changeSubscription(UsersSubscription subscription) {
        this.subscriptions.changeSubscription(subscription);
    }

    @Override
    public boolean isChanged() {
        return this.subscriptions.isChanged();
    }

    @Override
    public Map<BareJID, UsersSubscription> getChanged() {
        return this.subscriptions.getChanged();
    }

    @Override
    public void merge() {
        this.subscriptions.merge();
    }

    @Override
    public void resetChangedFlag() {
        this.subscriptions.resetChangedFlag();
    }

    public String toString() {
        return "PresenceNodeSubscriptions{extension=" + String.valueOf((Object)this.extension) + ", nodeName=" + this.nodeName + ", serviceJID=" + String.valueOf(this.serviceJID) + ", subscriptions=" + String.valueOf(this.subscriptions) + "}";
    }
}

