/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.UUID;
import java.util.logging.Level;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.eventbus.EventBus;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AccessModel;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.SendLastPublishedItem;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.AbstractConfigCreateNode;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.utils.PubSubLogic;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@Bean(name="nodeCreateModule", parent=PubSubComponent.class, active=true)
public class NodeCreateModule
extends AbstractConfigCreateNode {
    private static final Criteria CRIT_CREATE = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"create"));
    private final LeafNodeConfig defaultPepNodeConfig = new LeafNodeConfig("default-pep");
    @Inject
    private EventBus eventBus;
    @Inject
    private PublishItemModule publishModule;

    public NodeCreateModule() {
        this.defaultPepNodeConfig.setValue("pubsub#access_model", AccessModel.presence.name());
        this.defaultPepNodeConfig.setValue("pubsub#presence_based_delivery", true);
        this.defaultPepNodeConfig.setValue("pubsub#send_last_published_item", "on_sub_and_presence");
    }

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#create-and-configure", "http://jabber.org/protocol/pubsub#collections", "http://jabber.org/protocol/pubsub#create-nodes", "http://jabber.org/protocol/pubsub#instant-nodes", "http://jabber.org/protocol/pubsub#multi-collection", "http://jabber.org/protocol/pubsub#access-authorize", "http://jabber.org/protocol/pubsub#access-open", "http://jabber.org/protocol/pubsub#access-presence", "http://jabber.org/protocol/pubsub#access-roster", "http://jabber.org/protocol/pubsub#access-whitelist"};
    }

    public Criteria getModuleCriteria() {
        return CRIT_CREATE;
    }

    public void process(Packet packet) throws PubSubException {
        BareJID toJid = packet.getStanzaTo().getBareJID();
        Element element = packet.getElement();
        Element pubSub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub");
        Element create = pubSub.getChild("create");
        Element configure = pubSub.getChild("configure");
        String nodeName = create.getAttributeStaticStr("node");
        try {
            Element x;
            boolean instantNode;
            boolean bl = instantNode = nodeName == null;
            if (instantNode) {
                nodeName = UUID.randomUUID().toString().replaceAll("-", "");
            }
            if (this.getRepository().getNodeConfig(toJid, nodeName) != null) {
                throw new PubSubException(element, Authorization.CONFLICT);
            }
            NodeType nodeType = NodeType.leaf;
            String collection = null;
            LeafNodeConfig defaultNodeConfig = this.defaultNodeConfig;
            if (this.pubSubLogic.isServiceJidPEP(toJid)) {
                defaultNodeConfig = this.defaultPepNodeConfig;
            }
            AbstractNodeConfig nodeConfig = new LeafNodeConfig(nodeName, defaultNodeConfig);
            if (configure != null && (x = configure.getChild("x", "jabber:x:data")) != null && "submit".equals(x.getAttributeStaticStr("type"))) {
                for (Element field : x.getChildren()) {
                    if (!"field".equals(field.getName())) continue;
                    String var = field.getAttributeStaticStr("var");
                    String val = null;
                    Element value = field.getChild("value");
                    if (value != null) {
                        val = value.getCData();
                    }
                    if ("pubsub#node_type".equals(var)) {
                        nodeType = val == null ? NodeType.leaf : NodeType.valueOf(val);
                    } else if ("pubsub#collection".equals(var)) {
                        collection = val;
                    }
                    if (val != null && !this.config.isSendLastPublishedItemOnPresence() && "pubsub#send_last_published_item".equals(var) && SendLastPublishedItem.on_sub_and_presence.name().equals(val)) {
                        throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Requested on_sub_and_presence mode for sending last published item is disabled.");
                    }
                    nodeConfig.setValue(var, val);
                }
            }
            this.pubSubLogic.checkPermission(toJid, collection, packet.getStanzaFrom(), PubSubLogic.Action.manageNode);
            if (nodeType == NodeType.collection) {
                Form f = nodeConfig.getForm();
                nodeConfig = new CollectionNodeConfig(nodeConfig.getNodeName());
                nodeConfig.copyFromForm(f);
                nodeConfig.setNodeType(NodeType.collection);
            }
            CollectionNodeConfig colNodeConfig = null;
            if (collection != null) {
                AbstractNodeConfig absNodeConfig = this.getRepository().getNodeConfig(toJid, collection);
                if (absNodeConfig == null) {
                    throw new PubSubException(element, Authorization.ITEM_NOT_FOUND);
                }
                if (absNodeConfig.getNodeType() == NodeType.leaf) {
                    throw new PubSubException(element, Authorization.NOT_ALLOWED);
                }
                colNodeConfig = (CollectionNodeConfig)absNodeConfig;
            }
            if (nodeType != NodeType.leaf && nodeType != NodeType.collection) {
                throw new PubSubException(Authorization.NOT_ALLOWED);
            }
            this.getRepository().createNode(toJid, nodeName, packet.getStanzaFrom().getBareJID(), nodeConfig, nodeType, collection == null ? "" : collection);
            ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(toJid, nodeName);
            IAffiliations nodeaAffiliations = this.getRepository().getNodeAffiliations(toJid, nodeName);
            if (this.config.isAutoSubscribeNodeCreator()) {
                nodeSubscriptions.addSubscriberJid(packet.getStanzaFrom().getBareJID(), Subscription.subscribed);
            }
            nodeaAffiliations.addAffiliation(packet.getStanzaFrom().getBareJID(), Affiliation.owner);
            this.getRepository().update(toJid, nodeName, nodeaAffiliations);
            this.getRepository().update(toJid, nodeName, nodeSubscriptions);
            if (colNodeConfig == null) {
                this.getRepository().addToRootCollection(toJid, nodeName);
            }
            this.eventBus.fire((Object)new NodeCreatedEvent(this.config.getComponentName(), toJid, nodeName));
            Packet result = packet.okResult((Element)null, 0);
            if (collection != null) {
                Element colE = new Element("collection", new String[]{"node"}, new String[]{collection});
                colE.addChild((XMLNodeIfc)new Element("associate", new String[]{"node"}, new String[]{nodeName}));
                this.publishModule.generateNodeNotifications(packet.getStanzaTo().getBareJID(), collection, colE, null, false);
            }
            Element ps = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
            Element cr = new Element("create", new String[]{"node"}, new String[]{nodeName});
            ps.addChild((XMLNodeIfc)cr);
            result.getElement().addChild((XMLNodeIfc)ps);
            this.packetWriter.write(result);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error processing node create packet", e);
            throw new RuntimeException(e);
        }
    }

    public static class NodeCreatedEvent {
        public final String componentName;
        public final String node;
        public final BareJID serviceJid;

        public NodeCreatedEvent(String componentName, BareJID serviceJid, String node) {
            this.componentName = componentName;
            this.serviceJid = serviceJid;
            this.node = node;
        }
    }
}

