/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.component.PacketWriter;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="manageSubscriptionModule", parent=PubSubComponent.class, active=true)
public class ManageSubscriptionModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub#owner")).add((Criteria)ElementCriteria.name((String)"subscriptions"));
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    private static Packet createSubscriptionNotification(JID fromJid, JID toJid, String nodeName, Subscription subscription) {
        Packet message = Message.getMessage((JID)fromJid, (JID)toJid, null, null, null, null, null);
        Element pubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
        message.getElement().addChild((XMLNodeIfc)pubsub);
        Element affilations = new Element("subscriptions", new String[]{"node"}, new String[]{nodeName});
        pubsub.addChild((XMLNodeIfc)affilations);
        affilations.addChild((XMLNodeIfc)new Element("subscription", new String[]{"jid", "subscription"}, new String[]{toJid.toString(), subscription.name()}));
        return message;
    }

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#manage-subscriptions"};
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public void process(Packet packet) throws PubSubException {
        block7: {
            try {
                BareJID toJid = packet.getStanzaTo().getBareJID();
                Element element = packet.getElement();
                Element pubsub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub#owner");
                Element subscriptions = pubsub.getChild("subscriptions");
                String nodeName = subscriptions.getAttributeStaticStr("node");
                StanzaType type = packet.getType();
                if (nodeName == null) {
                    throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.NODE_REQUIRED);
                }
                AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(toJid, nodeName);
                if (nodeConfig == null) {
                    throw new PubSubException(Authorization.ITEM_NOT_FOUND);
                }
                ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(toJid, nodeName);
                IAffiliations nodeAffiliations = this.getRepository().getNodeAffiliations(toJid, nodeName);
                JID senderJid = packet.getStanzaFrom();
                this.checkPrivileges(type, element, senderJid, nodeConfig, nodeAffiliations, nodeSubscriptions);
                if (type == StanzaType.get) {
                    this.processGet(packet, subscriptions, nodeName, nodeSubscriptions, this.packetWriter);
                    break block7;
                }
                if (type == StanzaType.set) {
                    this.processSet(packet, subscriptions, nodeName, nodeConfig, nodeSubscriptions, this.packetWriter);
                    break block7;
                }
                throw new PubSubException(Authorization.BAD_REQUEST);
            }
            catch (PubSubException e1) {
                throw e1;
            }
            catch (Exception e) {
                this.log.log(Level.FINE, "Error processing subscription packet", e);
                throw new RuntimeException(e);
            }
        }
    }

    private void checkPrivileges(StanzaType type, Element element, JID senderJid, AbstractNodeConfig nodeConfig, IAffiliations nodeAffiliations, ISubscriptions nodeSubscriptions) throws PubSubException {
        boolean allowed = false;
        if (!allowed && type == StanzaType.get && nodeConfig.isAllowToViewSubscribers()) {
            Subscription senderSubscription = nodeSubscriptions.getSubscription(senderJid.getBareJID());
            boolean bl = allowed = senderSubscription == Subscription.subscribed;
        }
        if (!allowed) {
            UsersAffiliation senderAffiliation = nodeAffiliations.getSubscriberAffiliation(senderJid.getBareJID());
            boolean bl = allowed = senderAffiliation.getAffiliation() == Affiliation.owner;
        }
        if (!allowed && this.config.isAdmin(senderJid)) {
            allowed = true;
        }
        if (!allowed) {
            throw new PubSubException(element, Authorization.FORBIDDEN);
        }
    }

    private void processGet(Packet packet, Element subscriptions, String nodeName, ISubscriptions nodeSubscriptions, PacketWriter packetWriter) throws RepositoryException, PubSubException {
        Element ps = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#owner"});
        Packet iq = packet.okResult(ps, 0);
        Element afr = new Element("subscriptions", new String[]{"node"}, new String[]{nodeName});
        SubscriptionFilter subscriptionFilter = null;
        Element filterE = subscriptions.getChild("filter", "tigase:pubsub:1");
        if (filterE != null) {
            subscriptionFilter = new SubscriptionFilter(this, filterE);
        }
        ps.addChild((XMLNodeIfc)afr);
        Stream<UsersSubscription> subscribers = nodeSubscriptions.getSubscriptions().filter(usersSubscription -> usersSubscription.getSubscription() != Subscription.none);
        if (subscriptionFilter != null) {
            subscribers = subscribers.filter(subscriptionFilter::match);
        }
        subscribers.map(usersSubscription -> new Element("subscription", new String[]{"jid", "subscription"}, new String[]{usersSubscription.getJid().toString(), usersSubscription.getSubscription().name()})).forEach(arg_0 -> ((Element)afr).addChild(arg_0));
        this.getRepository().update(packet.getStanzaTo().getBareJID(), nodeName, nodeSubscriptions);
        packetWriter.write(iq);
    }

    private void processSet(Packet packet, Element subscriptions, String nodeName, AbstractNodeConfig nodeConfig, ISubscriptions nodeSubscriptions, PacketWriter packetWriter) throws PubSubException, RepositoryException {
        List subss = subscriptions.getChildren();
        for (Object a : subss) {
            if ("subscription".equals(a.getName())) continue;
            throw new PubSubException(Authorization.BAD_REQUEST);
        }
        HashMap<JID, Subscription> changedSubscriptions = new HashMap<JID, Subscription>();
        for (Element element : subss) {
            String strSubscription = element.getAttributeStaticStr("subscription");
            String jidStr = element.getAttributeStaticStr("jid");
            JID jid = JID.jidInstanceNS((String)jidStr);
            if (strSubscription == null) continue;
            Subscription newSubscription = Subscription.valueOf(strSubscription);
            Subscription oldSubscription = nodeSubscriptions.getSubscription(jid.getBareJID());
            Subscription subscription = oldSubscription = oldSubscription == null ? Subscription.none : oldSubscription;
            if (oldSubscription == Subscription.none && newSubscription != Subscription.none) {
                nodeSubscriptions.addSubscriberJid(jid.getBareJID(), newSubscription);
                changedSubscriptions.put(jid, newSubscription);
                continue;
            }
            nodeSubscriptions.changeSubscription(jid.getBareJID(), newSubscription);
            changedSubscriptions.put(jid, newSubscription);
        }
        this.getRepository().update(packet.getStanzaTo().getBareJID(), nodeName, nodeSubscriptions);
        for (Map.Entry entry : changedSubscriptions.entrySet()) {
            if (!nodeConfig.isTigaseNotifyChangeSubscriptionAffiliationState()) continue;
            packetWriter.write(ManageSubscriptionModule.createSubscriptionNotification(packet.getStanzaTo(), (JID)entry.getKey(), nodeName, (Subscription)((Object)entry.getValue())));
        }
        Packet iq = packet.okResult((Element)null, 0);
        packetWriter.write(iq);
    }

    private class SubscriptionFilter {
        private String jidContains;

        public SubscriptionFilter(ManageSubscriptionModule manageSubscriptionModule, Element f) throws PubSubException {
            for (Element e : f.getChildren()) {
                if ("jid".equals(e.getName())) {
                    this.jidContains = e.getAttributeStaticStr("contains");
                    continue;
                }
                throw new PubSubException(Authorization.BAD_REQUEST, "Unknown filter '" + e.getName() + "'");
            }
        }

        public boolean match(UsersSubscription usersSubscription) {
            boolean match = true;
            if (this.jidContains != null) {
                match = match && usersSubscription.getJid().toString().contains(this.jidContains);
            }
            return match;
        }
    }
}

