/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.Presence;
import tigase.server.xmppsession.SessionManager;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPStopListenerIfc;
import tigase.xmpp.impl.JabberIqPrivate;
import tigase.xmpp.impl.ServiceDiscovery;
import tigase.xmpp.impl.VCardTemp;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="pep", parent=SessionManager.class, active=true)
public class PepPlugin
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPStopListenerIfc,
ServiceDiscovery.AccountServiceProvider {
    protected static final String PUBSUB_XMLNS = "http://jabber.org/protocol/pubsub";
    protected static final String PUBSUB_XMLNS_OWNER = "http://jabber.org/protocol/pubsub#owner";
    protected static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub"}), new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub#owner"}), new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub#publish"}), new Element("identity", new String[]{"category", "type"}, new String[]{"pubsub", "pep"})};
    protected static final String DISCO_INFO_XMLNS = "http://jabber.org/protocol/disco#info";
    protected static final String DISCO_ITEMS_XMLNS = "http://jabber.org/protocol/disco#items";
    protected static final String[][] ELEMENTS = new String[][]{Iq.IQ_PUBSUB_PATH, Iq.IQ_PUBSUB_PATH, {"presence"}, Iq.IQ_QUERY_PATH};
    protected static final String[] XMLNSS = new String[]{"http://jabber.org/protocol/pubsub#owner", "http://jabber.org/protocol/pubsub", "jabber:client", "jabber:iq:private"};
    private static final String CAPS_XMLNS = "http://jabber.org/protocol/caps";
    private static final String ID = "pep";
    private static final Logger log = Logger.getLogger(PepPlugin.class.getCanonicalName());
    private static final String[] PRESENCE_C_PATH = new String[]{"presence", "c"};
    private static final Set<StanzaType> TYPES = new HashSet<StanzaType>(Arrays.asList(null, StanzaType.available, StanzaType.unavailable, StanzaType.get, StanzaType.set, StanzaType.result, StanzaType.error));
    private static final Element BOOKMARKS_CONVERSION_PUBLISH_OPTIONS = Optional.ofNullable(null).orElseGet(() -> {
        Element optionsEl = new Element("publish-options");
        DataForm.Builder builder = new DataForm.Builder(optionsEl, Command.DataType.submit);
        builder.addField(DataForm.FieldType.Hidden, "FORM_TYPE").setValue("http://jabber.org/protocol/pubsub#publish-options").build();
        builder.addField(DataForm.FieldType.Boolean, "pubsub#persist_items").setValue(Boolean.valueOf(true)).build();
        builder.addField(DataForm.FieldType.Fixed, "pubsub#access_model").setValue("whitelist").build();
        builder.build();
        return optionsEl;
    });
    protected final Set<String> simpleNodes = new HashSet<String>(Arrays.asList("http://jabber.org/protocol/tune", "http://jabber.org/protocol/mood", "http://jabber.org/protocol/activity", "http://jabber.org/protocol/geoloc", "urn:xmpp:avatar:data", "urn:xmpp:avatar:metadata"));
    @ConfigField(desc="PubSub Component JID", alias="pubsub-jid")
    protected JID pubsubJid = JID.jidInstanceNS((String)"pubsub", (String)DNSResolverFactory.getInstance().getDefaultHost(), null);
    @ConfigField(desc="Enable simple PEP", alias="simple-pep-enabled")
    protected boolean simplePepEnabled = false;
    @Inject(nullAllowed=true)
    private JabberIqPrivate jabberIqPrivateProcessor;
    @Inject(nullAllowed=true)
    private VCardTemp vcardTempProcessor;
    private Element[] discoFeatures = DISCO_FEATURES;

    public String id() {
        return ID;
    }

    public int concurrentQueuesNo() {
        return super.concurrentQueuesNo() * 2;
    }

    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        switch (packet.getElemName()) {
            case "iq": {
                this.processIq(packet, session, results);
                break;
            }
            case "presence": {
                this.processPresence(packet, session, results);
            }
        }
    }

    public void setJabberIqPrivateProcessor(JabberIqPrivate jabberIqPrivateProcessor) {
        this.jabberIqPrivateProcessor = jabberIqPrivateProcessor;
        this.updateDiscoFeatures();
    }

    public void setVcardTempProcessor(VCardTemp vcardTempProcessor) {
        this.vcardTempProcessor = vcardTempProcessor;
        this.updateDiscoFeatures();
    }

    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return this.discoFeatures;
    }

    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    public String[] supNamespaces() {
        return XMLNSS;
    }

    public Set<StanzaType> supTypes() {
        return TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            block5: {
                try {
                    Packet packet = Presence.packetInstance((String)"presence", (String)session.getJID().toString(), (String)session.getJID().copyWithoutResource().toString(), (StanzaType)StanzaType.unavailable);
                    this.processPresence(packet, session, results);
                }
                catch (TigaseStringprepException | NotAuthorizedException e) {
                    if (!log.isLoggable(Level.FINER)) break block5;
                    log.log(Level.FINER, "Problem forwarding unavailable presence to PubSub component");
                }
            }
        }
    }

    public JID getServiceProviderComponentJid() {
        return this.pubsubJid;
    }

    protected JID getPubsubJid(XMPPResourceConnection session, JID serviceJid) {
        return this.pubsubJid;
    }

    protected void processIq(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws XMPPException {
        Element storageEl;
        Element infoEl;
        String itemId;
        Element publishEl;
        Element queryEl = packet.getElemChild("query", "jabber:iq:private");
        if (queryEl != null) {
            this.processJabberIqPrivateToPubSubConversion(packet, queryEl, session, results::offer);
            return;
        }
        if (this.vcardTempProcessor != null && packet.getStanzaFrom() != null && packet.getStanzaTo() != null && packet.getType() == StanzaType.result && packet.getStanzaTo().getBareJID().equals((Object)packet.getStanzaFrom().getBareJID()) && packet.getAttributeStaticStr("id") != null && packet.getAttributeStaticStr("id").startsWith("sm-query-vcard-pep-")) {
            this.vcardTempProcessor.pepToVCardTemp_onDataRetrieved(packet, session);
            return;
        }
        if (session != null && session.isServerSession()) {
            return;
        }
        Element pubsubEl = packet.getElement().findChildStaticStr(Iq.IQ_PUBSUB_PATH);
        if (pubsubEl != null && this.simplePepEnabled) {
            boolean simple;
            boolean bl = simple = pubsubEl.findChild(c -> this.simpleNodes.contains(c.getAttributeStaticStr("node"))) != null;
            if (simple) {
                return;
            }
        }
        if (packet.getStanzaTo() != null && packet.getStanzaTo().getResource() != null) {
            if (pubsubEl != null && (pubsubEl.getXMLNS() == PUBSUB_XMLNS || pubsubEl.getXMLNS() == PUBSUB_XMLNS_OWNER)) {
                XMPPResourceConnection con;
                Packet result = null;
                if (session != null && session.getParentSession() != null && (con = session.getParentSession().getResourceForResource(packet.getStanzaTo().getResource())) != null) {
                    result = packet.copyElementOnly();
                    result.setPacketTo(con.getConnectionId());
                    result.setPacketFrom(packet.getTo());
                }
                if (result == null) {
                    result = Authorization.RECIPIENT_UNAVAILABLE.getResponseMessage(packet, "The recipient is no longer available.", true);
                }
                results.offer(result);
            }
            return;
        }
        if (!(session == null || packet.getStanzaTo() == null || session.isAuthorized() && session.isUserId(packet.getStanzaTo().getBareJID()))) {
            results.offer(packet.copyElementOnly());
            return;
        }
        if (packet.getStanzaTo() == null) {
            if (pubsubEl == null || pubsubEl.getXMLNS() != PUBSUB_XMLNS && pubsubEl.getXMLNS() != PUBSUB_XMLNS_OWNER) {
                log.log(Level.FINEST, "got <iq/> packet with no ''to'' attribute = {0}", packet);
                return;
            }
        } else if (packet.getStanzaTo().getResource() == null && packet.getType() == StanzaType.error && packet.getType() == StanzaType.result) {
            return;
        }
        Packet result = packet.copyElementOnly();
        if (packet.getStanzaTo() == null && session != null) {
            JID userJid = JID.jidInstance((BareJID)session.getBareJID());
            result.initVars(packet.getStanzaFrom() != null ? packet.getStanzaFrom() : session.getJID(), userJid);
        }
        if (packet.getStanzaFrom() == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "received <iq/> packet to forward to PubSub component without ''from'' attribute, dropping packet = {0}", packet);
            }
            return;
        }
        result.setPacketFrom(packet.getFrom());
        result.setPacketTo(this.getPubsubJid(session, packet.getStanzaTo()));
        results.offer(result);
        if (this.vcardTempProcessor != null && pubsubEl != null && packet.getType() == StanzaType.set && session != null && packet.getStanzaFrom() != null && session.isAuthorized() && session.isUserId(packet.getStanzaFrom().getBareJID()) && (publishEl = pubsubEl.getChild("publish")) != null && "urn:xmpp:avatar:metadata".equals(publishEl.getAttributeStaticStr("node")) && (itemId = publishEl.getChildAttributeStaticStr("item", "id")) != null && (infoEl = publishEl.findChildStaticStr(new String[]{"publish", "item", "metadata", "info"})) != null && infoEl.getAttributeStaticStr("url") == null) {
            String mimeType = Optional.ofNullable(infoEl.getAttributeStaticStr("type")).orElse("image/png");
            this.vcardTempProcessor.pepToVCardTemp_onPublication(packet.getStanzaFrom().getBareJID(), session, itemId, mimeType, () -> this.getPubsubJid(session, packet.getStanzaFrom()), results::offer);
        }
        if (this.jabberIqPrivateProcessor != null && packet.getType() == StanzaType.set && session != null && packet.getStanzaFrom() != null && session.isAuthorized() && session.isUserId(packet.getStanzaFrom().getBareJID()) && (publishEl = pubsubEl.getChild("publish")) != null && "storage:bookmarks".equals(publishEl.getAttributeStaticStr("node")) && (storageEl = publishEl.findChildStaticStr(new String[]{"publish", "item", "storage"})) != null && "storage:bookmarks".equals(storageEl.getXMLNS())) {
            try {
                session.setData("jabber:iq:private", storageEl.getName() + storageEl.getXMLNS(), storageEl.toString());
            }
            catch (TigaseDBException ex) {
                log.log(Level.FINEST, "could not update bookmarks store in the private storage", ex);
            }
        }
    }

    protected void processPresence(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        boolean forward = false;
        if (PepPlugin.isAvailablePresence(packet)) {
            if (PepPlugin.isCapsPacket(packet)) {
                forward = PepPlugin.isNotMucPacket(packet);
            }
        } else if (packet.getType() == StanzaType.unavailable) {
            forward = true;
        }
        if (!forward) {
            return;
        }
        if (packet.getStanzaTo() == null && session != null && session.isAuthorized() || packet.getStanzaTo() != null && packet.getStanzaTo().getResource() == null && (session == null || !session.isAuthorized() || session.isUserId(packet.getStanzaTo().getBareJID()))) {
            Packet result = packet.copyElementOnly();
            if (packet.getStanzaTo() == null || packet.getStanzaFrom() == null) {
                if (session == null || packet.getStanzaTo() != null && session.isAuthorized() && session.isUserId(packet.getStanzaTo().getBareJID())) {
                    return;
                }
                JID userJid = JID.jidInstance((BareJID)session.getBareJID());
                result.initVars(session.getJID(), userJid);
            }
            result.setPacketTo(this.getPubsubJid(session, packet.getStanzaTo()));
            results.offer(result);
        }
    }

    private static boolean isNotMucPacket(Packet packet) {
        return packet.getElement().getChild("x", "http://jabber.org/protocol/muc#user") == null;
    }

    private static boolean isAvailablePresence(Packet packet) {
        return packet.getType() == null || packet.getType() == StanzaType.available;
    }

    private static boolean isCapsPacket(Packet packet) {
        return packet.getElement().getXMLNSStaticStr(PRESENCE_C_PATH) == CAPS_XMLNS;
    }

    protected void processJabberIqPrivateToPubSubConversion(Packet packet, Element queryEl, XMPPResourceConnection session, Consumer<Packet> writer) throws PacketErrorTypeException, NotAuthorizedException {
        if (packet.getStanzaTo() != null && !session.isUserId(packet.getStanzaTo().getBareJID())) {
            writer.accept(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, "You are not authorized to access this private storage.", true));
            return;
        }
        if (this.jabberIqPrivateProcessor == null) {
            writer.accept(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, null, true));
            return;
        }
        switch (packet.getType()) {
            case get: {
                return;
            }
            case set: {
                Element storage = queryEl.getChild("storage", "storage:bookmarks");
                if (storage == null) {
                    return;
                }
                Iq iq = new Iq(new Element("iq", new String[]{"xmlns", "type"}, new String[]{"jabber:client", "set"}), session.getJID(), JID.jidInstanceNS((BareJID)session.getBareJID()));
                iq.getElement().withElement("pubsub", PUBSUB_XMLNS, pubsubEl -> {
                    pubsubEl.withElement("publish", publishEl -> {
                        publishEl.setAttribute("node", "storage:bookmarks");
                        publishEl.withElement("item", itemEl -> {
                            itemEl.setAttribute("id", "current");
                            itemEl.addChild((XMLNodeIfc)storage);
                        });
                    });
                    pubsubEl.addChild((XMLNodeIfc)BOOKMARKS_CONVERSION_PUBLISH_OPTIONS);
                });
                iq.setPacketTo(this.getPubsubJid(session, session.getJID()));
                writer.accept((Packet)iq);
                break;
            }
            default: {
                writer.accept(Authorization.BAD_REQUEST.getResponseMessage(packet, null, true));
            }
        }
    }

    private void updateDiscoFeatures() {
        Stream<Element> stream = Arrays.stream(DISCO_FEATURES);
        if (this.vcardTempProcessor != null) {
            stream = Stream.concat(stream, Stream.of(new Element("feature", new String[]{"var"}, new String[]{"urn:xmpp:pep-vcard-conversion:0"})));
        }
        if (this.jabberIqPrivateProcessor != null) {
            stream = Stream.concat(stream, Stream.of(new Element("feature", new String[]{"var"}, new String[]{"urn:xmpp:bookmarks-conversion:0"})));
        }
        this.discoFeatures = (Element[])stream.toArray(Element[]::new);
    }
}

