/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.utils;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import tigase.pubsub.utils.FragmentedMap;

public class FragmentedMapTest
extends TestCase {
    private Map<String, String> f1;
    private Map<String, String> f2;
    private Map<String, String> f3;
    private FragmentedMap<String, String> fm;

    @Before
    public void setUp() {
        this.f1 = new HashMap<String, String>();
        this.f1.put("k-1-1", "v-1-1");
        this.f1.put("k-1-2", "v-1-2");
        this.f1.put("k-1-3", "v-1-3");
        this.f1.put("k-1-4", "v-1-4");
        this.f2 = new HashMap<String, String>();
        this.f2.put("k-2-1", "v-2-1");
        this.f2.put("k-2-2", "v-2-2");
        this.f2.put("k-2-3", "v-2-3");
        this.f2.put("k-2-4", "v-2-4");
        this.f3 = new HashMap<String, String>();
        this.f3.put("k-3-1", "v-3-1");
        this.f3.put("k-3-2", "v-3-2");
        this.f3.put("k-3-3", "v-3-3");
        this.f3.put("k-3-4", "v-3-4");
        this.fm = new FragmentedMap(4);
    }

    @Test
    public void test01() {
        Assert.assertEquals((int)0, (int)this.fm.getFragmentsCount());
        this.fm.addFragment(this.f1);
        Assert.assertEquals((int)1, (int)this.fm.getFragmentsCount());
        this.fm.addFragment(this.f2);
        Assert.assertEquals((int)2, (int)this.fm.getFragmentsCount());
        this.fm.addFragment(this.f3);
        Assert.assertEquals((int)3, (int)this.fm.getFragmentsCount());
        Assert.assertEquals((int)0, (int)this.fm.getChangedFragmentIndexes().size());
        Assert.assertEquals((int)0, (int)this.fm.getRemovedFragmentIndexes().size());
        this.fm.remove((Object)"k-2-2");
        Assert.assertEquals((int)1, (int)this.fm.getChangedFragmentIndexes().size());
    }

    @Test
    public void test02() {
        HashMap<CallSite, CallSite> f = new HashMap<CallSite, CallSite>();
        for (int i = 0; i < 12; ++i) {
            f.put((CallSite)((Object)("k-1-" + i)), (CallSite)((Object)("v-1-" + i)));
        }
        this.fm.addFragment(f);
        Assert.assertEquals((int)3, (int)this.fm.getFragmentsCount());
    }
}

