/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.utils;

import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.pubsub.utils.Cache;
import tigase.pubsub.utils.LRUCache;
import tigase.pubsub.utils.LRUCacheWithFuture;
import tigase.stats.StatisticsList;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

public class CacheTest {
    private static String[][] nodes = new String[0][];

    @BeforeClass
    public static void prepareNodes() {
        Random random = new Random();
        nodes = new String[10][];
        for (int j = 0; j < 10; ++j) {
            CacheTest.nodes[j] = new String[100000];
            for (int i = 0; i < 100000; ++i) {
                CacheTest.nodes[j][i] = "node-" + String.valueOf(random.nextInt(8000));
            }
        }
    }

    @Test
    public void testLRUCache() throws Cache.CacheException {
        this.testCache((Cache<CachedPubSubRepository.NodeKey, String>)new LRUCache(2000));
    }

    @Test
    public void testLRUCacheWithFuture() throws Cache.CacheException {
        this.testCache((Cache<CachedPubSubRepository.NodeKey, String>)new LRUCacheWithFuture(2000));
    }

    private void testCache(Cache<CachedPubSubRepository.NodeKey, String> cache) throws Cache.CacheException {
        CachedPubSubRepository.NodeKey nodeKey = this.newNodeKey("test-1");
        Assert.assertNull((Object)cache.get((Object)nodeKey));
        Assert.assertEquals((Object)"test-2", (Object)cache.computeIfAbsent((Object)nodeKey, () -> "test-2"));
        Assert.assertEquals((Object)"test-2", (Object)cache.put((Object)nodeKey, (Object)"test-3"));
        Assert.assertEquals((Object)"test-3", (Object)cache.get((Object)nodeKey));
        cache.remove((Object)nodeKey);
        Assert.assertNull((Object)cache.get((Object)nodeKey));
    }

    private CachedPubSubRepository.NodeKey newNodeKey(String node) {
        BareJID serviceJid = BareJID.bareJIDInstanceNS((String)"test@test.com");
        return new CachedPubSubRepository.NodeKey(serviceJid, node);
    }

    @Test
    public void testLRUCacheCompute() throws TigaseStringprepException, InterruptedException {
        for (int y = 0; y < 1; ++y) {
            LRUCache cache = new LRUCache(2000);
            BareJID serviceJid = BareJID.bareJIDInstance((String)"test@test.com");
            ExecutorService service = Executors.newFixedThreadPool(10);
            for (int j = 0; j < 5; ++j) {
                String[] nodes = CacheTest.nodes[j];
                service.submit(() -> {
                    for (int i = 0; i < 5; ++i) {
                        try {
                            int x = i;
                            CachedPubSubRepository.NodeKey key = new CachedPubSubRepository.NodeKey(serviceJid, nodes[i]);
                            cache.computeIfAbsent((Object)key, () -> {
                                this.sleep();
                                return String.valueOf(x);
                            });
                            cache.get((Object)key);
                            continue;
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
            service.shutdown();
            while (!service.isTerminated()) {
                service.awaitTermination(20L, TimeUnit.MILLISECONDS);
            }
            cache.everyMinute();
            StatisticsList list = new StatisticsList(Level.FINEST);
            cache.getStatistics("tmp", list);
        }
    }

    @Test
    public void testLRUCacheWithFutureCompute() throws TigaseStringprepException, InterruptedException {
        for (int y = 0; y < 1; ++y) {
            LRUCacheWithFuture cache = new LRUCacheWithFuture(2000);
            BareJID serviceJid = BareJID.bareJIDInstance((String)"test@test.com");
            ExecutorService service = Executors.newFixedThreadPool(10);
            for (int j = 0; j < 5; ++j) {
                String[] nodes = CacheTest.nodes[j];
                service.submit(() -> {
                    for (int i = 0; i < 5; ++i) {
                        int x = i;
                        CachedPubSubRepository.NodeKey key = new CachedPubSubRepository.NodeKey(serviceJid, nodes[i]);
                        try {
                            cache.computeIfAbsent((Object)key, () -> {
                                this.sleep();
                                return String.valueOf(x);
                            });
                            cache.get((Object)key);
                            continue;
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            Assert.assertNull((String)"Got exception:", (Object)e);
                        }
                    }
                });
            }
            service.shutdown();
            while (!service.isTerminated()) {
                service.awaitTermination(20L, TimeUnit.MILLISECONDS);
            }
            cache.everyMinute();
            StatisticsList list = new StatisticsList(Level.FINEST);
            cache.getStatistics("tmp", list);
        }
    }

    @Test
    public void testSizedCache() throws TigaseStringprepException, InterruptedException {
        for (int y = 0; y < 1; ++y) {
            CachedPubSubRepository.SizedCache cache = new CachedPubSubRepository.SizedCache(2000);
            Map map = Collections.synchronizedMap(cache);
            BareJID serviceJid = BareJID.bareJIDInstance((String)"test@test.com");
            ExecutorService service = Executors.newFixedThreadPool(10);
            for (int j = 0; j < 5; ++j) {
                String[] nodes = CacheTest.nodes[j];
                service.submit(() -> {
                    for (int i = 0; i < 5; ++i) {
                        CachedPubSubRepository.NodeKey key = new CachedPubSubRepository.NodeKey(serviceJid, nodes[i]);
                        this.sleep();
                        map.put(key, String.valueOf(i));
                        map.get(key);
                    }
                });
            }
            service.shutdown();
            while (!service.isTerminated()) {
                service.awaitTermination(20L, TimeUnit.MILLISECONDS);
            }
            cache.everyMinute();
            StatisticsList list = new StatisticsList(Level.FINEST);
            cache.getStatistics("tmp", list);
        }
    }

    private void sleep() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

