/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.converter;

import org.junit.Assert;
import org.junit.Test;
import tigase.pubsub.Subscription;
import tigase.pubsub.repository.converter.PubSubNodeConverter;

public class PubSubNodeConverterTest {
    @Test
    public void getParentTest1() {
        Assert.assertEquals((Object)"/node1/node2/node3", (Object)PubSubNodeConverter.getParent((String)"/node1/node2/node3/leaf"));
    }

    @Test
    public void getParentTestRoot1() {
        Assert.assertNull((Object)PubSubNodeConverter.getParent((String)"/"));
    }

    @Test
    public void getParentTestRoot2() {
        Assert.assertNull((Object)PubSubNodeConverter.getParent((String)""));
    }

    @Test
    public void getParentNull() {
        Assert.assertNull((Object)PubSubNodeConverter.getParent(null));
    }

    @Test
    public void ParseArrayValue() {
        String[] strings = PubSubNodeConverter.parseArrayValue((String)"   [   value1   , value2,value3   ]   ");
        Assert.assertEquals((long)3L, (long)strings.length);
        Assert.assertEquals((Object)"value1", (Object)strings[0]);
        Assert.assertEquals((Object)"value2", (Object)strings[1]);
        Assert.assertEquals((Object)"value3", (Object)strings[2]);
    }

    @Test
    public void decodeSubscriptionFromDb() {
        Assert.assertEquals((Object)Subscription.subscribed, (Object)PubSubNodeConverter.decodeSubscription((String)"s:6088692ACAC13"));
        Assert.assertEquals((Object)Subscription.subscribed, (Object)PubSubNodeConverter.decodeSubscription((String)"s"));
    }
}

