/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import tigase.pubsub.Utils;

public class UtilsTest {
    @Test
    public void testRemoveMySQLNonUtf8mb3Codepoints() {
        String input = "7??0??1??\ud83d\udcb2";
        String output = Utils.removeMySQLNonUtf8mb3Codepoints((String)input);
        System.out.println(Base64.getEncoder().encodeToString(input.getBytes(Charset.forName("UTF-8"))) + " - " + input.getBytes(Charset.forName("UTF-8")).length);
        System.out.println(Base64.getEncoder().encodeToString(output.getBytes(Charset.forName("UTF-8"))) + " - " + output.getBytes(Charset.forName("UTF-8")).length);
        Assert.assertNotEquals((Object)input, (Object)output);
        Assert.assertEquals((long)(input.getBytes(Charset.forName("UTF8")).length - 3), (long)output.getBytes(Charset.forName("UTF8")).length);
        Assert.assertEquals((Object)"7??0??1??_", (Object)output);
    }

    @Ignore
    @Test
    public void test() throws NoSuchAlgorithmException {
        int i;
        Utils.Spi spi = new Utils.Spi(new Random());
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (i = 0; i < 1000; ++i) {
            byte[] bytes = new byte[13];
            spi.engineNextBytes(bytes, 1);
            list.add(bytes);
        }
        for (i = 0; i < 1000; ++i) {
            for (int j = 0; j < 1000; ++j) {
                if (i == j) continue;
                String x1 = new BigInteger((byte[])list.get(i)).toString(36);
                String x2 = new BigInteger((byte[])list.get(j)).toString(36);
                Assert.assertNotEquals((String)("At possitions " + i + ", " + j + "found collision!"), (Object)x1, (Object)x2);
            }
        }
    }

    @Ignore
    @Test
    public void concurrencyTest() throws NoSuchAlgorithmException, InterruptedException {
        final Utils.Spi spi = new Utils.Spi(new Random());
        ArrayList<1> tasks = new ArrayList<1>();
        for (int i = 0; i < 1000; ++i) {
            tasks.add(new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    byte[] bytes = new byte[13];
                    spi.engineNextBytes(bytes, 1);
                    return bytes;
                }
            });
        }
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 4);
        List futures = executorService.invokeAll(tasks);
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            Thread.sleep(1000L);
        }
        List list = futures.stream().map(f -> {
            try {
                return (byte[])f.get();
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }).collect(Collectors.toList());
        for (int i = 0; i < 1000; ++i) {
            for (int j = 0; j < 1000; ++j) {
                if (i == j) continue;
                String x1 = new BigInteger((byte[])list.get(i)).toString(36);
                String x2 = new BigInteger((byte[])list.get(j)).toString(36);
                Assert.assertNotEquals((String)("At possitions " + i + ", " + j + "found collision!"), (Object)x1, (Object)x2);
            }
        }
    }
}

