/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.upload.commands;

import java.util.Optional;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.db.TigaseDBException;
import tigase.http.upload.db.FileUploadRepository;
import tigase.kernel.beans.Inject;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.server.Packet;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public abstract class QueryUsedSpaceCommandAbstract
implements AdHocCommand {
    @Inject
    private FileUploadRepository repository;
    @Inject
    private AdHocCommandModule.ScriptCommandProcessor scriptCommandProcessor;
    private final boolean isAdmin;

    protected QueryUsedSpaceCommandAbstract(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        if (request.isAction("cancel")) {
            response.cancelSession();
            return;
        }
        try {
            Optional<BareJID> user;
            Optional<BareJID> optional = user = this.isAdmin ? Optional.ofNullable(Command.getFieldValue((Packet)request.getIq(), (String)"jid")).map(BareJID::bareJIDInstanceNS) : Optional.of(request.getSender().getBareJID());
            if (user.isEmpty()) {
                DataForm.Builder formBuilder = new DataForm.Builder(Command.DataType.form).withField(DataForm.FieldType.JidSingle, "jid", field -> {
                    DataForm.Field.Builder builder = field.setLabel("JID");
                });
                response.getElements().add(formBuilder.build());
                response.setNewState(AdHocResponse.State.executing);
            } else {
                if (!request.getSender().getBareJID().equals((Object)user.get()) && !this.scriptCommandProcessor.isAllowed(this.getNode(), user.get().getDomain(), request.getSender())) {
                    throw new AdHocCommandException(Authorization.FORBIDDEN);
                }
                long usedSpace = this.repository.getUsedSpaceForUser(user.get());
                DataForm.Builder formBuilder = new DataForm.Builder(Command.DataType.result);
                if (this.isAdmin) {
                    formBuilder.withField(DataForm.FieldType.Fixed, "jid", field -> {
                        DataForm.Field.Builder builder = field.setLabel("JID").setValue(((BareJID)user.get()).toString());
                    });
                }
                formBuilder.withField(DataForm.FieldType.TextSingle, "used-space", field -> {
                    DataForm.Field.Builder builder = field.setLabel("Used space").setValue(String.valueOf(usedSpace));
                });
                response.getElements().add(formBuilder.build());
                response.completeSession();
            }
        }
        catch (TigaseDBException tigaseDBException) {
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR);
        }
    }

    public String getName() {
        return "Query space used by uploaded files";
    }

    public String getNode() {
        return "query-space-used";
    }

    public boolean isAllowedFor(JID jid) {
        return this.scriptCommandProcessor.isAllowed(this.getNode(), jid);
    }
}

