/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup.pages;

import gg.jte.TemplateOutput;
import gg.jte.output.StringOutput;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.servlet.http.HttpServletRequest;
import tigase.conf.ConfigHolder;
import tigase.http.api.HttpException;
import tigase.http.modules.setup.SetupModule;
import tigase.http.modules.setup.pages.AbstractPage;
import tigase.kernel.beans.Bean;

@Path(value="/saveConfig")
@Bean(name="saveConfigPage", parent=SetupModule.class, active=true)
public class SaveConfigPage
extends AbstractPage {
    private static final System.Logger logger = System.getLogger(SaveConfigPage.class.getName());

    @Override
    public String getTitle() {
        return "Saving configuration";
    }

    @GET
    public Response getConfigForm() {
        StringOutput output = new StringOutput();
        this.engine.render("saveConfig.jte", this.prepareContext(), (TemplateOutput)output);
        return Response.ok((Object)output.toString(), (String)"text/html").build();
    }

    @POST
    public Response processForm(HttpServletRequest request, @FormParam(value="config") String config) throws HttpException {
        logger.log(System.Logger.Level.TRACE, "Saving config: \n" + config);
        java.nio.file.Path configPath = Paths.get(ConfigHolder.TDSL_CONFIG_FILE_DEF, new String[0]);
        try {
            File f = configPath.toFile();
            if (configPath.toFile().exists()) {
                ConfigHolder.backupOldConfigFile((java.nio.file.Path)configPath);
            } else {
                f.createNewFile();
            }
            Files.writeString(configPath, (CharSequence)config, new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new HttpException(ex, 500);
        }
        StringOutput output = new StringOutput();
        this.engine.render("finished.jte", this.prepareContext(), (TemplateOutput)output);
        return Response.ok((Object)output.toString(), (String)"text/html").build();
    }
}

