/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.setup;

import jakarta.ws.rs.FormParam;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import tigase.conf.ConfigBuilder;
import tigase.conf.ConfigWriter;
import tigase.db.util.DBSchemaLoader;
import tigase.db.util.SchemaLoader;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.server.ConnectionManager;
import tigase.server.extdisco.ExtServiceDiscoItem;
import tigase.server.xmppsession.SessionManager;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.setup.SetupHelper;
import tigase.util.ui.console.CommandlineParameter;
import tigase.xmpp.XMPPImplIfc;
import tigase.xmpp.jid.BareJID;

public class Config {
    private String companyName;
    private ConfigTypeEnum configType = ConfigTypeEnum.DefaultMode;
    private String defaultVirtualDomain = System.getenv().getOrDefault("DEFAULT_VIRTUAL_DOMAIN", DNSResolverFactory.getInstance().getDefaultHost());
    private Set<BareJID> admins = new HashSet<BareJID>();
    private String adminPwd;
    private SchemaLoader.TypeInfo dbType = DBSchemaLoader.getSupportedTypeForName((String)System.getenv("DB_TYPE")).orElse((SchemaLoader.TypeInfo)SchemaLoader.getDefaultSupportedTypeForName().orElseThrow());
    private Set<String> connectors = new HashSet<String>();
    private Set<String> features = new HashSet<String>();
    private boolean clusterMode = false;
    private boolean acs = false;
    private DBConfig dbConfig = DBConfig.getDefaults();
    private SetupHelper.HttpSecurity httpSecurity = new SetupHelper.HttpSecurity();
    private String setupPassword;
    private String setupUser;
    private VoipConfig voipConfig = VoipConfig.getDefaults();

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public ConfigTypeEnum getConfigType() {
        return this.configType;
    }

    public void setConfigType(ConfigTypeEnum configType) {
        this.configType = configType;
        this.connectors = SetupHelper.getAvailableComponents().stream().filter(def -> !def.isCoreComponent()).filter(def -> {
            ConfigType ct = def.getClazz().getAnnotation(ConfigType.class);
            return ct == null || Arrays.asList(ct.value()).contains(this.configType);
        }).filter(def -> ConnectionManager.class.isAssignableFrom(def.getClazz())).filter(def -> def.isActive()).map(def -> def.getName()).collect(Collectors.toSet());
        Set defComponents = SetupHelper.getAvailableComponents().stream().filter(def -> !def.isCoreComponent()).filter(def -> {
            ConfigType ct = def.getClazz().getAnnotation(ConfigType.class);
            return ct == null || Arrays.asList(ct.value()).contains(this.configType);
        }).filter(def -> def.isActive()).map(def -> def.getName()).collect(Collectors.toSet());
        Set defPlugins = SetupHelper.getAvailableProcessors(SessionManager.class, XMPPImplIfc.class).stream().filter(def -> def.isActive()).filter(def -> this.configType == ConfigTypeEnum.DefaultMode || this.configType == ConfigTypeEnum.SessionManagerMode).filter(def -> {
            ConfigType ct = def.getClazz().getAnnotation(ConfigType.class);
            return ct == null || Arrays.asList(ct.value()).contains(this.configType.name());
        }).map(def -> def.getName()).collect(Collectors.toSet());
        this.features.clear();
        if (defComponents.contains("muc")) {
            this.features.add("muc");
        }
        if (defComponents.contains("pubsub") || defPlugins.stream().filter(it -> it.equals("pep")).findFirst().isPresent()) {
            this.features.add("pubsub");
        }
        if (defComponents.contains("mix")) {
            this.features.add("mix");
        }
        if (defComponents.contains("message-archive") || defPlugins.stream().filter(it -> it.startsWith("urn:xmpp:mam:")).findFirst().isPresent()) {
            this.features.add("mam");
        }
        if (defPlugins.contains("urn:xmpp:push:0")) {
            this.features.add("push");
        }
        if (defComponents.contains("upload")) {
            this.features.add("upload");
        }
        if (defPlugins.contains("message-carbons")) {
            this.features.add("carbons");
        }
        if (defPlugins.contains("urn:xmpp:csi:0")) {
            this.features.add("csi");
        }
        if (defPlugins.contains("motd")) {
            this.features.add("motd");
        }
        if (defPlugins.contains("jabber:iq:last-marker")) {
            this.features.add("lastActivity");
        }
        if (defPlugins.contains("spam-filter")) {
            this.features.add("spam");
        }
    }

    public String getDefaultVirtualDomain() {
        return this.defaultVirtualDomain;
    }

    public void setDefaultVirtualDomain(String defaultVirtualDomain) {
        this.defaultVirtualDomain = defaultVirtualDomain;
    }

    public Set<BareJID> getAdmins() {
        if (this.admins.isEmpty()) {
            this.admins.add(BareJID.bareJIDInstanceNS((String)("admin@" + this.defaultVirtualDomain)));
        }
        return this.admins;
    }

    public void setAdmins(Set<BareJID> admins) {
        this.admins = admins;
    }

    public String getAdminPwd() {
        return this.adminPwd;
    }

    public void setAdminPwd(String adminPwd) {
        this.adminPwd = adminPwd;
    }

    public SchemaLoader.TypeInfo getDbType() {
        return this.dbType;
    }

    public void setDbType(SchemaLoader.TypeInfo dbType) {
        this.dbType = dbType;
    }

    public void setConnectors(Set<String> connectors) {
        this.connectors = connectors;
    }

    public boolean isConnectorEnabled(String name) {
        return this.connectors.contains(name);
    }

    public void setFeatures(Set<String> features) {
        this.features = features;
    }

    public boolean isFeatureEnabled(String name) {
        return this.features.contains(name);
    }

    public boolean isACSEnabled() {
        return this.isClusterMode() && this.acs;
    }

    public void setACSEnabled(boolean value) {
        this.acs = value;
    }

    public boolean isClusterMode() {
        return this.clusterMode;
    }

    public void setClusterMode(boolean clusterMode) {
        this.clusterMode = clusterMode;
    }

    public boolean installationContainsACS() {
        try {
            Class.forName("tigase.licence.LicenceChecker");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public DBConfig getDbConfig() {
        return this.dbConfig;
    }

    public void setDbConfig(DBConfig dbConfig) {
        this.dbConfig = dbConfig;
    }

    public VoipConfig getVoipConfig() {
        return this.voipConfig;
    }

    public void setVoipConfig(VoipConfig voipConfig) {
        this.voipConfig = voipConfig;
    }

    public String getSetupUser() {
        return this.httpSecurity.setupUser;
    }

    public void setSetupUser(String setupUser) {
        this.httpSecurity.setupUser = setupUser;
    }

    public String getSetupPassword() {
        return this.httpSecurity.setupPassword;
    }

    public void setSetupPassword(String setupPassword) {
        this.httpSecurity.setupPassword = setupPassword;
    }

    public Map<String, Object> getAsMap() {
        HashSet<String> components = new HashSet<String>(this.connectors);
        HashSet<String> plugins = new HashSet<String>();
        Set<String> manuallyManagerComponents = Set.of("muc", "pubsub", "mix", "message-archive", "upload");
        Set connectionManagers = SetupHelper.getAvailableComponents().stream().filter(def -> !def.isCoreComponent()).filter(def -> {
            ConfigType ct = def.getClazz().getAnnotation(ConfigType.class);
            return ct == null || Arrays.asList(ct.value()).contains(this.configType);
        }).filter(def -> ConnectionManager.class.isAssignableFrom(def.getClazz())).filter(def -> def.isActive()).map(def -> def.getName()).collect(Collectors.toSet());
        SetupHelper.getAvailableComponents().stream().filter(def -> !def.isCoreComponent()).filter(def -> {
            ConfigType ct = def.getClazz().getAnnotation(ConfigType.class);
            return ct == null || Arrays.asList(ct.value()).contains(this.configType);
        }).filter(def -> def.isActive()).map(def -> def.getName()).filter(name -> !manuallyManagerComponents.contains(name)).filter(name -> !connectionManagers.contains(name)).forEach(components::add);
        Set<String> manuallyManagedPlugins = Set.of("pep", "urn:xmpp:mam:1", "urn:xmpp:mam:2", "urn:xmpp:push:0", "message-carbons", "urn:xmpp:csi:0", "motd", "jabber:iq:last-marker", "spam-filter");
        SetupHelper.getAvailableProcessors(SessionManager.class, XMPPImplIfc.class).stream().filter(def -> def.isActive()).filter(def -> this.configType == ConfigTypeEnum.DefaultMode || this.configType == ConfigTypeEnum.SessionManagerMode).filter(def -> {
            ConfigType ct = def.getClazz().getAnnotation(ConfigType.class);
            return ct == null || Arrays.asList(ct.value()).contains(this.configType.name());
        }).map(def -> def.getName()).filter(name -> !manuallyManagedPlugins.contains(name)).forEach(plugins::add);
        if (this.features.contains("muc")) {
            components.add("muc");
        }
        if (this.features.contains("pubsub")) {
            components.add("pubsub");
            plugins.add("pep");
        }
        if (this.features.contains("mix")) {
            components.add("mix");
        }
        if (this.features.contains("mam")) {
            components.add("message-archive");
            plugins.addAll(List.of("urn:xmpp:mam:1", "urn:xmpp:mam:2"));
        }
        if (this.features.contains("push")) {
            plugins.add("urn:xmpp:push:0");
        }
        if (this.features.contains("upload")) {
            components.add("upload");
        }
        if (this.features.contains("carbons")) {
            plugins.add("message-carbons");
        }
        if (this.features.contains("csi")) {
            plugins.add("urn:xmpp:csi:0");
        }
        if (this.features.contains("motd")) {
            plugins.add("motd");
        }
        if (this.features.contains("lastActivity")) {
            plugins.add("jabber:iq:last-marker");
        }
        if (this.features.contains("spam")) {
            plugins.add("spam-filter");
        }
        ConfigBuilder builder = SetupHelper.generateConfig((ConfigTypeEnum)this.configType, (String)this.dbConfig.getDbUri(this.dbType), (boolean)this.clusterMode, (boolean)this.acs, Optional.of(components), Optional.empty(), Optional.of(plugins), (String)this.defaultVirtualDomain, Optional.ofNullable((BareJID[])this.admins.stream().toArray(BareJID[]::new)), Optional.ofNullable(this.httpSecurity));
        return builder.build();
    }

    public String getAsDsl() {
        try {
            Map<String, Object> props = this.getAsMap();
            StringWriter w = new StringWriter();
            new ConfigWriter().write((Writer)w, props);
            return w.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static class DBConfig {
        @FormParam(value="dbName")
        private String dbName;
        @FormParam(value="dbHost")
        private String dbHost;
        @FormParam(value="dbUserName")
        private String dbUserName;
        @FormParam(value="dbUserPassword")
        private String dbUserPassword;
        @FormParam(value="dbRootName")
        private String dbRootName;
        @FormParam(value="dbRootPassword")
        private String dbRootPassword;
        @FormParam(value="dbUseSSL")
        private boolean dbUseSSL = true;
        @FormParam(value="dbAdditionalOptions")
        private String dbAdditionalOptions;
        @FormParam(value="useLegacyDatetimeCode")
        private boolean useLegacyDatetimeCode;

        public static DBConfig getDefaults() {
            DBConfig config = new DBConfig();
            config.dbName = DBSchemaLoader.PARAMETERS_ENUM.DATABASE_NAME.getDefaultValue();
            config.dbHost = System.getenv().getOrDefault("DB_HOST", DBSchemaLoader.PARAMETERS_ENUM.DATABASE_HOSTNAME.getDefaultValue());
            config.dbUserName = DBSchemaLoader.PARAMETERS_ENUM.TIGASE_USERNAME.getDefaultValue();
            config.dbUserPassword = DBSchemaLoader.PARAMETERS_ENUM.TIGASE_PASSWORD.getDefaultValue();
            config.dbRootName = System.getenv().getOrDefault("DB_ROOT_USER", DBSchemaLoader.PARAMETERS_ENUM.ROOT_USERNAME.getDefaultValue());
            config.dbRootPassword = System.getenv().getOrDefault("DB_ROOT_PASS", DBSchemaLoader.PARAMETERS_ENUM.ROOT_PASSWORD.getDefaultValue());
            config.dbUseSSL = Boolean.parseBoolean(DBSchemaLoader.PARAMETERS_ENUM.USE_SSL.getDefaultValue());
            config.useLegacyDatetimeCode = Boolean.parseBoolean(DBSchemaLoader.PARAMETERS_ENUM.USE_LEGACY_DATETIME_CODE.getDefaultValue());
            return config;
        }

        public String getDbName() {
            return this.dbName;
        }

        public void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public String getDbHost() {
            return this.dbHost;
        }

        public void setDbHost(String dbHost) {
            this.dbHost = dbHost;
        }

        public String getDbUserName() {
            return this.dbUserName;
        }

        public void setDbUserName(String dbUserName) {
            this.dbUserName = dbUserName;
        }

        public String getDbUserPassword() {
            return this.dbUserPassword;
        }

        public void setDbUserPassword(String dbUserPassword) {
            this.dbUserPassword = dbUserPassword;
        }

        public String getDbRootName() {
            return this.dbRootName;
        }

        public void setDbRootName(String dbRootName) {
            this.dbRootName = dbRootName;
        }

        public String getDbRootPassword() {
            return this.dbRootPassword;
        }

        public void setDbRootPassword(String dbRootPassword) {
            this.dbRootPassword = dbRootPassword;
        }

        public boolean isDbUseSSL() {
            return this.dbUseSSL;
        }

        public void setDbUseSSL(boolean dbUseSSL) {
            this.dbUseSSL = dbUseSSL;
        }

        public String getDbAdditionalOptions() {
            return this.dbAdditionalOptions;
        }

        public void setDbAdditionalOptions(String dbAdditionalOptions) {
            this.dbAdditionalOptions = dbAdditionalOptions;
        }

        public boolean hasDbRootCredentials() {
            return this.dbRootName != null && !this.dbRootName.isEmpty() || this.dbRootPassword != null && !this.dbRootPassword.isEmpty();
        }

        public String getDbUri(SchemaLoader.TypeInfo dbType) {
            if (dbType == null) {
                return null;
            }
            Properties props = new Properties();
            props.put(DBSchemaLoader.PARAMETERS_ENUM.ROOT_ASK.getName(), DBSchemaLoader.PARAMETERS_ENUM.ROOT_ASK.getDefaultValue());
            props.put(DBSchemaLoader.PARAMETERS_ENUM.DATABASE_TYPE.getName(), dbType.getName());
            SchemaLoader loader = SchemaLoader.newInstance((String)dbType.getName());
            for (CommandlineParameter param : loader.getSetupOptions()) {
                if (DBSchemaLoader.PARAMETERS_ENUM.DATABASE_NAME.getName().equals(param.getFullName().get())) {
                    props.put(param.getFullName().get(), this.dbName);
                    continue;
                }
                if (DBSchemaLoader.PARAMETERS_ENUM.DATABASE_HOSTNAME.getName().equals(param.getFullName().get())) {
                    props.put(param.getFullName().get(), this.dbHost);
                    continue;
                }
                if (DBSchemaLoader.PARAMETERS_ENUM.TIGASE_USERNAME.getName().equals(param.getFullName().get())) {
                    props.put(param.getFullName().get(), this.dbUserName);
                    continue;
                }
                if (DBSchemaLoader.PARAMETERS_ENUM.TIGASE_PASSWORD.getName().equals(param.getFullName().get())) {
                    props.put(param.getFullName().get(), this.dbUserPassword);
                    continue;
                }
                if (DBSchemaLoader.PARAMETERS_ENUM.DATABASE_OPTIONS.getName().equals(param.getFullName().get())) {
                    props.put(param.getFullName().get(), this.dbAdditionalOptions);
                    continue;
                }
                if (!DBSchemaLoader.PARAMETERS_ENUM.USE_LEGACY_DATETIME_CODE.getName().equals(param.getFullName().get())) continue;
                props.put(param.getFullName().get(), (Object)this.useLegacyDatetimeCode);
            }
            SchemaLoader.Parameters parameters = loader.createParameters();
            parameters.setProperties(props);
            parameters.setDbRootAsk(false);
            loader.init(parameters, Optional.empty());
            return loader.getDBUri();
        }
    }

    public static class VoipConfig {
        @FormParam(value="type")
        private Type type;
        @FormParam(value="host")
        private String host;
        @FormParam(value="port")
        private Integer port;
        @FormParam(value="requiresUsernameAndPassword")
        private boolean requiresUsernameAndPassword;
        @FormParam(value="username")
        private String username;
        @FormParam(value="password")
        private String password;
        @FormParam(value="transport")
        private Transport transport;

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public boolean isRequiresUsernameAndPassword() {
            return this.requiresUsernameAndPassword;
        }

        public void setRequiresUsernameAndPassword(boolean requiresUsernameAndPassword) {
            this.requiresUsernameAndPassword = requiresUsernameAndPassword;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public Transport getTransport() {
            return this.transport;
        }

        public void setTransport(Transport transport) {
            this.transport = transport;
        }

        public List<ExtServiceDiscoItem> toItems() {
            if (this.host == null || this.host.isEmpty() || this.port == null || this.port <= 0 || this.type == null) {
                return Collections.emptyList();
            }
            ExtServiceDiscoItem item = new ExtServiceDiscoItem();
            item.init("default", "default", this.host, this.port.intValue(), this.type.name(), this.transport != null ? this.transport.name() : null, this.requiresUsernameAndPassword, this.username, this.password);
            return List.of(item);
        }

        public static VoipConfig getDefaults() {
            VoipConfig config = new VoipConfig();
            config.type = Type.turn;
            config.port = 3478;
            return config;
        }

        public static enum Transport {
            tcp,
            udp;

        }

        public static enum Type {
            stun,
            stuns,
            turn,
            turns;

        }
    }
}

