/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.rest.users;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.http.api.rest.RestHandler;
import tigase.http.jaxrs.Handler;
import tigase.http.modules.rest.AbstractRestHandler;
import tigase.http.modules.rest.RestModule;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.xmpp.jid.BareJID;

@Bean(name="users", parent=RestModule.class, active=false)
@Path(value="/users")
public class UsersHandler
extends AbstractRestHandler {
    @Inject
    private UserRepository userRepository;

    public UsersHandler() {
        super(RestHandler.Security.ApiKey, Handler.Role.None);
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/xml"})
    public Users listUsers() throws TigaseDBException {
        List users = this.userRepository.getUsers();
        return new Users(users, users.size());
    }

    @GET
    @Path(value="/{domain}")
    @Produces(value={"application/json", "application/xml"})
    public Users listUsersFromDomain(@NotNull @PathParam(value="domain") String domain) throws TigaseDBException {
        List<BareJID> users = this.userRepository.getUsers().stream().filter(jid -> domain.equals(jid.getDomain())).collect(Collectors.toList());
        return new Users(users, users.size());
    }

    @GET
    @Path(value="/async")
    @Produces(value={"application/json", "application/xml"})
    public void listUsersAsync(@Suspended AsyncResponse response) {
        ArrayList<BareJID> jids = new ArrayList<BareJID>();
        int i = 0;
        while (i < 10) {
            jids.add(BareJID.bareJIDInstanceNS((String)("user-" + i), (String)"example.com"));
            ++i;
        }
        new Thread(() -> {
            try {
                Thread.sleep(2000L);
                response.resume((Object)new Users(jids, jids.size()));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }).start();
    }

    @XmlRootElement(name="users")
    public static class Users {
        @XmlElement(name="user")
        private List<BareJID> users;
        private int count;

        public Users(List<BareJID> users, int count) {
            this.users = users;
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public List<BareJID> getUsers() {
            return this.users;
        }

        public void setUsers(List<BareJID> users) {
            this.users = users;
        }
    }
}

