/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.rest.users;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import tigase.db.AuthRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.http.api.HttpException;
import tigase.http.api.NotFoundException;
import tigase.http.api.rest.RestHandler;
import tigase.http.jaxrs.Handler;
import tigase.http.modules.rest.AbstractRestHandler;
import tigase.http.modules.rest.RestModule;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.xmpp.jid.BareJID;

@Bean(name="user", parent=RestModule.class, active=false)
@Path(value="/user")
public class UserHandler
extends AbstractRestHandler {
    @Inject
    private AuthRepository authRepository;
    @Inject
    private UserRepository userRepository;

    public UserHandler() {
        super(RestHandler.Security.ApiKey, Handler.Role.None);
    }

    @GET
    @Path(value="/{userJid}")
    @Produces(value={"application/json", "application/xml"})
    public User getUser(@NotNull @PathParam(value="userJid") BareJID userJid) throws HttpException {
        if (!this.userRepository.userExists(userJid)) {
            throw new NotFoundException("User does not exist!");
        }
        return new User(userJid, userJid.getDomain(), null);
    }

    @PUT
    @Path(value="/{userJid}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public User createUser(@NotNull @PathParam(value="userJid") BareJID userJid, @Valid @NotNull UserCreate form) throws HttpException, TigaseDBException {
        if (this.userRepository.userExists(userJid)) {
            throw new HttpException("User already exists!", 409);
        }
        this.authRepository.addUser(userJid, form.password);
        this.userRepository.setData(userJid, "email", form.email);
        return new User(userJid, userJid.getDomain(), Result.created);
    }

    @POST
    @Path(value="/{userJid}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public User changeUser(@NotNull @PathParam(value="userJid") BareJID userJid, @Valid @NotNull UserChange form) throws NotFoundException, TigaseDBException {
        if (!this.userRepository.userExists(userJid)) {
            throw new NotFoundException("User does not exist!");
        }
        this.authRepository.updateCredential(userJid, "default", form.password);
        if (form.email != null && !form.email.isEmpty()) {
            this.userRepository.setData(userJid, "email", form.email);
        }
        return new User(userJid, userJid.getDomain(), Result.updated);
    }

    @DELETE
    @Path(value="/{userJid}")
    @Produces(value={"application/json", "application/xml"})
    public User removeUser(@NotNull @PathParam(value="userJid") BareJID userJid) throws NotFoundException, TigaseDBException {
        if (!this.userRepository.userExists(userJid)) {
            throw new NotFoundException("User does not exist!");
        }
        this.authRepository.removeUser(userJid);
        try {
            this.userRepository.removeUser(userJid);
        }
        catch (UserNotFoundException userNotFoundException) {}
        return new User(userJid, userJid.getDomain(), Result.deleted);
    }

    public static enum Result {
        created,
        updated,
        deleted;

    }

    @XmlRootElement(name="user")
    public static class User {
        @XmlAttribute
        @NotNull
        private BareJID jid;
        @XmlAttribute
        @NotNull
        private String domain;
        @XmlAttribute
        private Result result;

        public User(BareJID userJid, String domain, Result result) {
            this.jid = userJid;
            this.domain = domain;
            this.result = result;
        }

        public BareJID getJid() {
            return this.jid;
        }

        public void setJid(BareJID jid) {
            this.jid = jid;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public Result getResult() {
            return this.result;
        }

        public void setResult(Result result) {
            this.result = result;
        }
    }

    @XmlRootElement(name="user")
    public static class UserChange {
        @XmlElement
        @NotNull
        private String password;
        @XmlElement
        private String email;

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }
    }

    @XmlRootElement(name="user")
    public static class UserCreate {
        @XmlElement
        @NotNull
        private String password;
        @XmlElement
        @NotNull
        private String email;

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }
    }
}

