/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.rest;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tigase.http.ServiceImpl;
import tigase.http.api.HttpException;
import tigase.http.api.rest.RestHandler;
import tigase.http.jaxrs.JaxRsRequestHandler;
import tigase.http.jaxrs.JaxRsServlet;
import tigase.http.jaxrs.RequestHandler;
import tigase.http.modules.rest.HandlersLoader;
import tigase.http.modules.rest.OldGroovyRequestHandler;
import tigase.http.modules.rest.OldGroovyResultEncoder;
import tigase.http.modules.rest.RestModule;
import tigase.http.rest.Handler;

public class RestServlet
extends JaxRsServlet<RestModule> {
    private static final Logger log = Logger.getLogger(RestServlet.class.getCanonicalName());
    private ServiceImpl<RestModule> service;
    public static final String SCRIPTS_DIR_KEY = "script-dir";
    private final OldGroovyResultEncoder oldGroovyResultEncoder = new OldGroovyResultEncoder();

    @Override
    public void init() throws ServletException {
        super.init();
        List<tigase.http.jaxrs.Handler> handlers = ((RestModule)this.module).getHandlers();
        for (tigase.http.jaxrs.Handler handler : handlers) {
            this.registerHandlers(JaxRsRequestHandler.create(handler));
        }
        this.service = new ServiceImpl<RestModule>((RestModule)this.module);
        this.initGroovyScripts();
    }

    private void initGroovyScripts() {
        ServletConfig cfg = this.getServletConfig();
        File rootScriptsDir = new File(cfg.getInitParameter(SCRIPTS_DIR_KEY));
        File[] scriptDirFiles = rootScriptsDir.listFiles(file -> file.isDirectory() && !"static".equals(file.getName()));
        ArrayList<Handler> allHandlers = new ArrayList<Handler>();
        if (scriptDirFiles != null) {
            File[] fileArray = scriptDirFiles;
            int n = scriptDirFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File scriptsDir = fileArray[n2];
                File[] scriptFiles = RestModule.getGroovyFiles(scriptsDir);
                if (scriptFiles != null) {
                    List<Handler> listOfHandlers = HandlersLoader.getInstance().loadHandlers(((RestModule)this.module).getKernel(), Arrays.asList(scriptFiles));
                    for (Handler handler : listOfHandlers) {
                        this.registerHandlers(OldGroovyRequestHandler.create(this.service, handler, scriptsDir.getName(), this.oldGroovyResultEncoder));
                    }
                    allHandlers.addAll(listOfHandlers);
                }
                ++n2;
            }
        }
        this.oldGroovyResultEncoder.loadTemplates(rootScriptsDir, allHandlers);
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String uri;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("comparing request URI = " + request.getRequestURI() + " with " + request.getContextPath() + request.getServletPath());
            }
            if ((uri = request.getRequestURI()).equals(request.getContextPath()) || uri.equals(request.getContextPath() + "/")) {
                HashMap<String, ServiceImpl<RestModule>> result = new HashMap<String, ServiceImpl<RestModule>>();
                result.put("service", this.service);
                this.oldGroovyResultEncoder.renderIndex(request, response, result);
                return;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        super.service(request, response);
    }

    @Override
    protected boolean canAccess(RequestHandler requestHandler, HttpServletRequest request, HttpServletResponse response) throws HttpException, IOException, ServletException {
        switch (((RestHandler)requestHandler.getHandler()).getSecurity()) {
            case None: {
                break;
            }
            case ApiKey: {
                this.checkApiKey(request);
            }
        }
        return super.canAccess(requestHandler, request, response);
    }

    protected void checkApiKey(HttpServletRequest request) throws HttpException {
        String apiKey = request.getHeader("Api-Key");
        if (apiKey == null) {
            apiKey = request.getParameter("api-key");
        }
        if (!this.service.isAllowed(apiKey, request.getServerName(), request.getRequestURI())) {
            if (apiKey == null) {
                throw new HttpException("Missing required 'Api-Key' header", 403);
            }
            throw new HttpException("Provided Api-Key is not authorized to access " + request.getRequestURI(), 403);
        }
    }
}

