/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.rest;

import java.util.Queue;
import javax.script.Bindings;
import tigase.db.comp.RepositoryItem;
import tigase.http.modules.rest.AbstractApiKeyCmd;
import tigase.http.modules.rest.ApiKeyItem;
import tigase.http.modules.rest.RestModule;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;

public class ApiKeyUpdateCmd
extends AbstractApiKeyCmd {
    private static final String ITEMS = "item-list";

    public ApiKeyUpdateCmd(RestModule module) {
        super(module);
    }

    public String getCommandId() {
        return "api-key-update";
    }

    public String getDescription() {
        return "Update API key";
    }

    public String getGroup() {
        return "Configuration";
    }

    public void runCommand(Iq packet, Bindings binds, Queue<Packet> results) {
        if (!this.checkIsFromAdmin(packet, results::offer)) {
            return;
        }
        String itemKey = Command.getFieldValue((Packet)packet, (String)ITEMS);
        if (itemKey == null) {
            String[] itemsStr = (String[])this.module.getApiKeyRepository().allItems().stream().map(ApiKeyItem::getKey).toArray(String[]::new);
            if (itemsStr.length > 0) {
                Iq result = (Iq)packet.commandResult(Command.DataType.form);
                Command.addFieldValue((Packet)result, (String)ITEMS, (String)itemsStr[0], (String)"List of items", (String[])itemsStr, (String[])itemsStr);
                results.offer((Packet)result);
            } else {
                Iq result = (Iq)packet.commandResult(Command.DataType.result);
                Command.addTextField((Packet)result, (String)"Note", (String)"There are no items on the list");
                results.offer((Packet)result);
            }
            return;
        }
        if (Command.getFieldValue((Packet)packet, (String)"command-marker") == null) {
            ApiKeyItem item = (ApiKeyItem)this.module.getApiKeyRepository().getItem(itemKey);
            if (item == null) {
                Iq result = (Iq)packet.commandResult(Command.DataType.result);
                Command.addHiddenField((Packet)result, (String)"command-marker", (String)"command-marker");
                Command.addTextField((Packet)result, (String)"Error", (String)"No such item, update impossible.");
                results.offer((Packet)result);
            } else {
                Iq result = (Iq)packet.commandResult(Command.DataType.form);
                item.addCommandFields((Packet)result);
                Command.addHiddenField((Packet)result, (String)"command-marker", (String)"command-marker");
                Command.addHiddenField((Packet)result, (String)ITEMS, (String)itemKey);
                results.offer((Packet)result);
            }
            return;
        }
        Iq result = (Iq)packet.commandResult(Command.DataType.result);
        ApiKeyItem item = this.module.getApiKeyRepository().getItemInstance();
        item.initFromCommand((Packet)packet);
        ApiKeyItem oldItem = (ApiKeyItem)this.module.getApiKeyRepository().getItem(itemKey);
        if (oldItem == null) {
            Command.addTextField((Packet)result, (String)"Error", (String)"The item you try to update does not exist.");
        } else {
            String validateResult = this.module.getApiKeyRepository().validateItem((RepositoryItem)item);
            if (validateResult == null) {
                this.module.getApiKeyRepository().addItem(item);
                Command.addTextField((Packet)result, (String)"Note", (String)"Operation successful");
            } else {
                Command.addTextField((Packet)result, (String)"Error", (String)"The item did not pass validation checking.");
                Command.addTextField((Packet)result, (String)"Note", (String)"   ");
                Command.addTextField((Packet)result, (String)"Warning", (String)validateResult);
            }
        }
        results.add((Packet)result);
    }
}

