/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dnswebservice.formatters;

import tigase.http.modules.dnswebservice.DnsEntry;
import tigase.http.modules.dnswebservice.DnsItem;

public class JsonUtilV2 {
    public static String format(DnsItem item) {
        StringBuilder sb = new StringBuilder();
        JsonUtilV2.format(sb, item);
        return sb.toString();
    }

    public static void format(StringBuilder sb, DnsItem item) {
        if (item == null) {
            sb.append("null");
            return;
        }
        sb.append("{ domain: '");
        sb.append(item.getDomain());
        sb.append("', c2s: [");
        JsonUtilV2.format(sb, item.getC2S());
        sb.append("], bosh: [");
        JsonUtilV2.format(sb, item.getBosh());
        sb.append("], websocket: [");
        JsonUtilV2.format(sb, item.getWebSocket());
        sb.append("]");
        sb.append("}");
    }

    public static void format(StringBuilder sb, DnsEntry[] entries) {
        if (entries != null && entries.length > 0) {
            int i = 0;
            while (i < entries.length) {
                if (i > 0) {
                    sb.append(",");
                }
                JsonUtilV2.format(sb, entries[i]);
                ++i;
            }
        }
    }

    public static void format(StringBuilder sb, DnsEntry entry) {
        sb.append("{");
        int i = 0;
        if (entry.getHost() != null) {
            sb.append("host: '");
            sb.append(entry.getHost());
            sb.append("'");
            ++i;
        }
        if (entry.getIPs() != null) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("ip: [");
            int j = 0;
            String[] stringArray = entry.getIPs();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ip = stringArray[n2];
                if (j > 0) {
                    sb.append(",");
                }
                sb.append("'");
                sb.append(ip);
                sb.append("'");
                ++j;
                ++n2;
            }
            sb.append("]");
            ++i;
        }
        if (entry.getPort() != 0) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("port: ");
            sb.append(entry.getPort());
            ++i;
        }
        if (entry.getURL() != null) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("url:'");
            sb.append(entry.getURL());
            sb.append("'");
            ++i;
        }
        if (entry.getPriority() != 0) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("priority: ");
            sb.append(entry.getPriority());
        }
        sb.append("}");
    }
}

