/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dashboard;

import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import javax.servlet.http.Part;
import tigase.db.DataSource;
import tigase.db.TigaseDBException;
import tigase.http.api.HttpException;
import tigase.http.jaxrs.Handler;
import tigase.http.jaxrs.Model;
import tigase.http.modules.dashboard.DashboardHandler;
import tigase.http.modules.dashboard.DashboardModule;
import tigase.http.modules.dashboard.PermissionsHelper;
import tigase.http.modules.dashboard.UserAvatarPool;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.util.Algorithms;
import tigase.xmpp.jid.BareJID;

@Bean(name="usersAvatarPoolHandler", parent=DashboardModule.class, active=true)
@Path(value="/usersAvatarPool")
public class UserAvatarPoolHandler
extends DashboardHandler {
    @Inject
    private PermissionsHelper permissionsHelper;
    @Inject
    private UserAvatarPool userAvatarPool;

    @Override
    public Handler.Role getRequiredRole() {
        return Handler.Role.None;
    }

    @GET
    @Path(value="")
    @Produces(value={"text/html"})
    @RolesAllowed(value={"admin", "account_manager"})
    public Response index(Model model) throws TigaseDBException {
        model.put("avatars", this.userAvatarPool.getKeys());
        String output = this.renderTemplate("usersAvatarPool/index.jte", model);
        return Response.ok((Object)output, (String)"text/html").build();
    }

    @GET
    @Path(value="/{key}")
    @RolesAllowed(value={"admin", "account_manager"})
    public Response avatar(@PathParam(value="key") String key) throws TigaseDBException {
        UserAvatarPool.Avatar avatar = this.userAvatarPool.getItem(key);
        if (avatar == null) {
            return Response.status((int)404).build();
        }
        return Response.ok((Object)avatar.data(), (String)avatar.mimeType()).expires(Date.from(LocalDateTime.now().plusHours(1L).atZone(ZoneOffset.systemDefault()).toInstant())).build();
    }

    @POST
    @Path(value="")
    @RolesAllowed(value={"admin", "account_manager"})
    public Response upload(@FormParam(value="file") Part filePart) throws IOException, NoSuchAlgorithmException, TigaseDBException {
        DataSource.log.finest(() -> "uploading avatar " + filePart.getContentType() + " of " + filePart.getSize());
        byte[] data = filePart.getInputStream().readAllBytes();
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(data);
        String id = Algorithms.bytesToHex((byte[])md.digest());
        this.userAvatarPool.setItem(new UserAvatarPool.Avatar(id, filePart.getContentType(), data.length, data));
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{key}")
    @RolesAllowed(value={"admin", "account_manager"})
    public Response deleteAvatar(@PathParam(value="key") String key) throws TigaseDBException {
        this.userAvatarPool.removeItem(key);
        return Response.ok().build();
    }

    @GET
    @Path(value="/assignRandom/{user}")
    @RolesAllowed(value={"admin", "account_manager"})
    public void assignRandom(@PathParam(value="user") BareJID userJid, @Suspended AsyncResponse response) throws TigaseDBException {
        if (!this.permissionsHelper.canManageUser(userJid)) {
            response.resume((Throwable)((Object)new HttpException("Forbidden", 403)));
            return;
        }
        this.userAvatarPool.setRandomAvatarToUser(userJid).whenComplete((r, ex) -> {
            if (ex != null) {
                response.resume(ex);
            } else {
                response.resume((Object)Response.ok().build());
            }
        });
    }
}

