/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dashboard;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserRepository;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.http.modules.dashboard.DashboardModule;
import tigase.http.modules.dashboard.UserAvatarRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.util.Base64;
import tigase.vhosts.VHostManagerIfc;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.jid.BareJID;

@Bean(name="userAvatarPool", parent=DashboardModule.class, active=true)
public class UserAvatarPool
implements Initializable,
UnregisterAware {
    private static final Logger log = Logger.getLogger(UserAvatarPool.class.getCanonicalName());
    private static final String SUBNODE = "user-avatar-pool";
    private static final Random random = new SecureRandom();
    @Inject
    private EventBus eventBus;
    @Inject
    private DashboardModule module;
    @Inject
    private UserRepository userRepository;
    @Inject
    private UserAvatarRepository userAvatarRepository;
    @Inject
    private VHostManagerIfc vHostManager;
    @ConfigField(desc="Enable user avatar pool")
    private boolean enable = false;
    private boolean initialized = false;

    public boolean isEnabled() {
        return this.enable;
    }

    public void beforeUnregister() {
        if (this.eventBus != null) {
            this.eventBus.unregisterAll((Object)this);
        }
    }

    public void initialize() {
        if (this.eventBus != null) {
            this.eventBus.registerAll((Object)this);
        }
    }

    public @NonNull List<@NonNull String> getKeys() throws TigaseDBException {
        this.initRepo();
        return Optional.ofNullable(this.userRepository.getKeys(this.getRepoUserJid(), SUBNODE)).map(stringArray -> Arrays.asList(stringArray)).orElseGet(Collections::emptyList);
    }

    public @Nullable Avatar getItem(@NonNull String key) throws TigaseDBException {
        this.initRepo();
        String data = this.userRepository.getData(this.getRepoUserJid(), SUBNODE, key);
        if (data == null) {
            return null;
        }
        DomBuilderHandler domHandler = new DomBuilderHandler();
        SimpleParser parser = SingletonFactory.getParserInstance();
        parser.parse((SimpleHandler)domHandler, data.toCharArray(), 0, data.length());
        Queue elems = domHandler.getParsedElements();
        Element el = elems == null ? null : (Element)elems.poll();
        return Avatar.parse(el);
    }

    public void setItem(@NonNull Avatar avatar) throws TigaseDBException {
        this.initRepo();
        this.userRepository.setData(this.getRepoUserJid(), SUBNODE, avatar.id(), avatar.toElement().toString());
    }

    public void removeItem(@NonNull String key) throws TigaseDBException {
        this.initRepo();
        this.userRepository.removeData(this.getRepoUserJid(), SUBNODE, key);
    }

    public @NonNull CompletableFuture<Void> setRandomAvatarToUser(BareJID userJid) {
        CompletionStage<Object> result;
        String key = "";
        try {
            List<String> keys = this.getKeys();
            key = keys.get(random.nextInt(0, keys.size()));
            Avatar avatar = this.getItem(key);
            result = avatar == null ? CompletableFuture.failedFuture(new RuntimeException("Requested avatar with id = " + key + " was not found!")) : this.userAvatarRepository.setData(userJid, avatar.id(), avatar.data()).thenCompose(r -> this.userAvatarRepository.setMetadata(userJid, new UserAvatarRepository.AvatarMetadata(avatar.id(), avatar.mimeType(), avatar.bytes(), null)));
        }
        catch (TigaseDBException ex2) {
            result = CompletableFuture.failedFuture(ex2);
        }
        String id = key;
        return result.whenComplete((r, ex) -> {
            if (ex == null) {
                log.info(() -> "setting avatar with id " + id + " for user " + String.valueOf(userJid) + " succeeded!");
            } else {
                log.log(Level.WARNING, (Throwable)ex, () -> "setting avatar with id " + id + " for user " + String.valueOf(userJid) + " failed!");
            }
        });
    }

    @HandleEvent
    public void onUserAdded(UserRepository.UserAddedEvent event) {
        log.info("received UserAddedEvent for " + String.valueOf(event.getJid()));
        if (!this.isEnabled()) {
            return;
        }
        if (this.vHostManager.isLocalDomain(event.getJid().getDomain())) {
            log.info("setting random avatar for " + String.valueOf(event.getJid()));
            this.setRandomAvatarToUser(event.getJid());
        }
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
        this.initialized = false;
    }

    private BareJID getRepoUserJid() {
        return this.module.getJid().getBareJID();
    }

    private void initRepo() {
        if (this.initialized) {
            return;
        }
        if (!this.userRepository.userExists(this.getRepoUserJid())) {
            try {
                this.userRepository.addUser(this.getRepoUserJid());
            }
            catch (UserExistsException userExistsException) {
            }
            catch (TigaseDBException ex) {
                throw new RuntimeException(ex);
            }
            this.initialized = true;
        }
    }

    public record Avatar(@NonNull String id, @NonNull String mimeType, long bytes, byte @NonNull [] data) {
        public static @Nullable Avatar parse(@Nullable Element element) {
            if (element == null || !Objects.equals("avatar", element.getName())) {
                return null;
            }
            String id = element.getAttributeStaticStr("id");
            String type = element.getAttributeStaticStr("type");
            long bytes = Optional.ofNullable(element.getAttributeStaticStr("bytes")).map(Long::parseLong).orElse(-1L);
            byte[] data = Optional.ofNullable(element.getCData()).map(Base64::decode).orElse(null);
            if (id == null || type == null || bytes <= 0L || data == null) {
                return null;
            }
            return new Avatar(id, type, bytes, data);
        }

        public @NonNull Element toElement() {
            Element result = new Element("avatar").withAttribute("id", this.id).withAttribute("type", this.mimeType).withAttribute("bytes", String.valueOf(this.bytes));
            result.setCData(Base64.encode((byte[])this.data));
            return result;
        }
    }
}

