/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dashboard;

import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Response;
import java.security.MessageDigest;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Part;
import tigase.http.api.HttpException;
import tigase.http.jaxrs.Handler;
import tigase.http.modules.dashboard.DashboardHandler;
import tigase.http.modules.dashboard.DashboardModule;
import tigase.http.modules.dashboard.PermissionsHelper;
import tigase.http.modules.dashboard.UserAvatarRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.util.Algorithms;
import tigase.xmpp.jid.BareJID;

@Bean(name="userAvatar", parent=DashboardModule.class, active=true)
@Path(value="/users")
public class UserAvatarHandler
extends DashboardHandler {
    private static final Logger log = Logger.getLogger(UserAvatarHandler.class.getCanonicalName());
    @Inject
    private UserAvatarRepository avatarRepository;
    @Inject
    private PermissionsHelper permissionsHelper;

    @Override
    public Handler.Role getRequiredRole() {
        return Handler.Role.User;
    }

    @GET
    @Path(value="/{user}/avatar/{id}")
    public void getAvatar(@PathParam(value="user") BareJID userJid, @PathParam(value="id") String id, @Suspended AsyncResponse response) {
        this.avatarRepository.getMetadata(userJid).thenCombine(this.avatarRepository.getData(userJid, id), (metadata, data) -> {
            try {
                if (metadata == null || data == null) {
                    response.resume((Object)Response.status((int)404));
                } else {
                    response.resume((Object)Response.ok((Object)data, (String)metadata.mimeType()).expires(Date.from(LocalDateTime.now().plusHours(1L).atZone(ZoneOffset.systemDefault()).toInstant())).build());
                }
            }
            catch (Throwable ex) {
                log.log(Level.WARNING, ex, () -> "failed to send avatar for user " + String.valueOf(userJid) + " with id " + id);
                response.resume(ex);
            }
            return null;
        });
    }

    @POST
    @Path(value="/{user}/avatar")
    @RolesAllowed(value={"admin", "account_manager", "user"})
    public void setAvatar(@PathParam(value="user") BareJID userJid, @FormParam(value="file") Part filePart, @Suspended AsyncResponse response) {
        try {
            if (!this.permissionsHelper.canManageUser(userJid)) {
                throw new HttpException("Forbidden", 403);
            }
            log.finest(() -> "setting avatar for user " + String.valueOf(userJid) + " to " + filePart.getContentType() + " of " + filePart.getSize());
            byte[] data = filePart.getInputStream().readAllBytes();
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(data);
            String id = Algorithms.bytesToHex((byte[])md.digest());
            ((CompletableFuture)this.avatarRepository.setData(userJid, id, data).thenCompose(r -> this.avatarRepository.setMetadata(userJid, new UserAvatarRepository.AvatarMetadata(id, filePart.getContentType(), data.length, null)))).whenComplete((r, ex) -> {
                if (ex == null) {
                    response.resume((Object)Response.ok().build());
                } else {
                    response.resume(ex);
                }
            });
        }
        catch (Throwable ex2) {
            response.resume(ex2);
        }
    }

    @DELETE
    @Path(value="/{user}/avatar")
    @RolesAllowed(value={"admin", "account_manager", "user"})
    public void deleteAvatar(@PathParam(value="user") BareJID userJid, @Suspended AsyncResponse response) {
        if (!this.permissionsHelper.canManageUser(userJid)) {
            response.resume((Throwable)((Object)new HttpException("Forbidden", 403)));
            return;
        }
        ((CompletableFuture)this.avatarRepository.getMetadata(userJid).thenCompose(metadata -> {
            if (metadata != null) {
                return this.avatarRepository.deleteMetadata(userJid);
            }
            return CompletableFuture.completedFuture(null);
        })).whenComplete((r, ex) -> {
            if (ex == null) {
                response.resume((Object)Response.ok().build());
            } else {
                response.resume(ex);
            }
        });
    }
}

