/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.dashboard;

import jakarta.ws.rs.core.SecurityContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.http.jaxrs.SecurityContextHolder;
import tigase.http.modules.dashboard.DashboardModule;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostManager;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="permissionsHelper", parent=DashboardModule.class, active=true)
public class PermissionsHelper {
    @Inject
    private DashboardModule dashboardModule;
    @Inject
    private UserRepository userRepository;
    @Inject
    private VHostManager vHostManager;
    @ConfigField(desc="User can create domain")
    private boolean userCanCreateDomain = false;

    public boolean canCreateDomain() {
        SecurityContext securityContext = SecurityContextHolder.getSecurityContext();
        if (securityContext == null) {
            return false;
        }
        if (securityContext.isUserInRole("admin")) {
            return true;
        }
        return securityContext.isUserInRole("user") && this.userCanCreateDomain;
    }

    public List<String> getManagedDomains(SecurityContext securityContext) {
        Stream<Object> domains = this.vHostManager.getAllVHosts().stream();
        if (!securityContext.isUserInRole("admin") && !securityContext.isUserInRole("account_manager")) {
            if (securityContext.isUserInRole("user")) {
                domains = domains.filter(domain -> this.canManageDomain(securityContext, domain.getDomain()));
            } else {
                return Collections.emptyList();
            }
        }
        return domains.map(JID::getDomain).filter(domain -> !"default".equals(domain)).sorted().toList();
    }

    public boolean canManageDomain(SecurityContext securityContext, String domain) {
        if (securityContext.isUserInRole("admin") || securityContext.isUserInRole("account_manager")) {
            return true;
        }
        VHostItem item = this.vHostManager.getVHostItem(domain);
        String user = securityContext.getUserPrincipal().getName();
        return item != null && (item.isAdmin(user) || item.isOwner(user));
    }

    public List<String> getUserRolesIds(BareJID user) throws TigaseDBException {
        String[] rolesFromRepo;
        ArrayList<String> roles = new ArrayList<String>();
        if (this.dashboardModule.isAdmin(user)) {
            roles.add("admin");
        }
        if ((rolesFromRepo = this.userRepository.getDataList(user, "roles", "roles")) != null) {
            roles.addAll(Arrays.asList(rolesFromRepo));
        }
        return roles;
    }

    public boolean canManageUser(BareJID jid) {
        block5: {
            SecurityContext securityContext;
            block6: {
                try {
                    securityContext = SecurityContextHolder.getSecurityContext();
                    if (securityContext == null) break block5;
                    if (!securityContext.isUserInRole("admin")) break block6;
                    return true;
                }
                catch (TigaseDBException tigaseDBException) {}
            }
            if (securityContext.isUserInRole("account_manager")) {
                List<String> managedUserRoles = this.getUserRolesIds(jid);
                return !managedUserRoles.contains("admin") && !managedUserRoles.contains("account_manager") || securityContext.getUserPrincipal().getName().equals(jid.toString());
            }
            if (securityContext.isUserInRole("user")) {
                return this.canManageDomain(securityContext, jid.getDomain()) || securityContext.getUserPrincipal().getName().equals(jid.toString());
            }
        }
        return false;
    }
}

