/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.modules.admin.form;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import tigase.http.modules.admin.form.Field;
import tigase.http.modules.admin.form.Reported;
import tigase.xml.Element;

public class Form {
    private final String title;
    private final String instructions;
    private final List<Field> fields = new ArrayList<Field>();
    private final List<Reported> reported = new ArrayList<Reported>();

    public Form(List<Element> items) {
        this.title = items.stream().filter(el -> el.getName() == "title").findFirst().map(Element::getCData).orElse(null);
        this.instructions = items.stream().filter(el -> el.getName() == "title").findFirst().map(Element::getCData).orElse(null);
        Optional<Object> reported = Optional.empty();
        for (Element el2 : items) {
            switch (el2.getName()) {
                case "reported": {
                    reported = Optional.of(new Reported(el2));
                    reported.ifPresent(this.reported::add);
                    break;
                }
                case "item": {
                    reported.ifPresent(r -> {
                        boolean bl = r.getItems().add(new Reported.Item(el2));
                    });
                    break;
                }
                case "field": {
                    reported = Optional.empty();
                    this.fields.add(new Field(el2));
                    break;
                }
                default: {
                    reported = Optional.empty();
                }
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public List<Reported> getReported() {
        return this.reported;
    }

    public List<Field> getFields() {
        return this.fields;
    }
}

