/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jaxrs;

import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriBuilderException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import tigase.http.jaxrs.MultivaluedMapImpl;

public class UriBuilderImpl
extends UriBuilder {
    private String scheme;
    private String userInfo;
    private String host;
    private String port;
    private final MultivaluedMap<String, String> queryParams = new MultivaluedMapImpl();
    private String fragment;
    private List<String> path = new ArrayList<String>();

    public UriBuilder clone() {
        UriBuilderImpl builder = new UriBuilderImpl();
        builder.scheme = this.scheme;
        builder.host = this.host;
        builder.port = this.port;
        for (Map.Entry e : this.queryParams.entrySet()) {
            builder.queryParams.addAll((Object)((String)e.getKey()), (List)e.getValue());
        }
        builder.fragment = this.fragment;
        builder.path = new ArrayList<String>(this.path);
        return builder;
    }

    public UriBuilder uri(URI uri) {
        this.scheme = uri.getScheme();
        this.host = uri.getHost();
        this.port = uri.getPort() > 0 ? String.valueOf(uri.getPort()) : null;
        this.path.clear();
        Optional.ofNullable(uri.getPath()).stream().flatMap(path -> Arrays.stream(path.split("/"))).filter(Predicate.not(String::isBlank)).forEach(this.path::add);
        this.queryParams.clear();
        Optional.ofNullable(uri.getQuery()).stream().flatMap(q -> Arrays.stream(q.split("&"))).map(p -> p.split("=")).forEach(pair -> {
            String key = pair[0];
            String value = ((String[])pair).length > 1 ? pair[1] : null;
            this.queryParams.add((Object)key, (Object)value);
        });
        this.fragment = uri.getFragment();
        return this;
    }

    public UriBuilder uri(String s) {
        return null;
    }

    public UriBuilder scheme(String s) {
        this.scheme = s;
        return this;
    }

    public UriBuilder schemeSpecificPart(String s) {
        return null;
    }

    public UriBuilder userInfo(String s) {
        return null;
    }

    public UriBuilder host(String s) {
        this.host = s;
        return this;
    }

    public UriBuilder port(int i) {
        this.port = i > 0 ? String.valueOf(i) : null;
        return this;
    }

    public UriBuilder replacePath(String s) {
        this.path.clear();
        return this.path(s);
    }

    public UriBuilder path(String s) {
        if (s != null) {
            Arrays.stream(s.split("/")).filter(Predicate.not(String::isBlank)).forEach(this.path::add);
        }
        return this;
    }

    public UriBuilder path(Class aClass) {
        Path path = aClass.getAnnotation(Path.class);
        if (path == null) {
            throw new RuntimeException("Class " + aClass.getCanonicalName() + " is not annotated with @Path!");
        }
        return this.path(path.value());
    }

    public UriBuilder path(Class aClass, String methodName) {
        List<Method> methods = Arrays.stream(aClass.getMethods()).filter(method -> methodName.equals(method.getName())).toList();
        if (methods.isEmpty()) {
            throw new RuntimeException("Class " + aClass.getCanonicalName() + " doesn't have method " + methodName + "!");
        }
        if (methods.size() > 1) {
            throw new RuntimeException("Class " + aClass.getCanonicalName() + " has multiple methods named " + methodName + "!");
        }
        return this.path(methods.get(0));
    }

    public UriBuilder path(Method method) {
        Path classPath = method.getDeclaringClass().getAnnotation(Path.class);
        Path methodPath = method.getAnnotation(Path.class);
        if (methodPath == null) {
            throw new RuntimeException("Method " + String.valueOf(method) + " is not annotated with @Path!");
        }
        return this.path(classPath != null ? classPath.value() : "").path(methodPath.value());
    }

    public UriBuilder segment(String ... strings) {
        return null;
    }

    public UriBuilder replaceMatrix(String s) {
        return null;
    }

    public UriBuilder matrixParam(String s, Object ... objects) {
        return null;
    }

    public UriBuilder replaceMatrixParam(String s, Object ... objects) {
        return null;
    }

    public UriBuilder replaceQuery(String s) {
        this.queryParams.clear();
        return this;
    }

    public UriBuilder queryParam(String s, Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != null) {
                this.queryParams.addAll((Object)s, (Object[])new String[]{o.toString()});
            }
            ++n2;
        }
        return this;
    }

    public UriBuilder replaceQueryParam(String s, Object ... objects) {
        this.queryParams.putSingle((Object)s, null);
        this.queryParam(s, objects);
        return this;
    }

    public UriBuilder fragment(String s) {
        this.fragment = s;
        return this;
    }

    public UriBuilder resolveTemplate(String s, Object o) {
        return null;
    }

    public UriBuilder resolveTemplate(String s, Object o, boolean b) {
        return null;
    }

    public UriBuilder resolveTemplateFromEncoded(String s, Object o) {
        return null;
    }

    public UriBuilder resolveTemplates(Map<String, Object> map) {
        return null;
    }

    public UriBuilder resolveTemplates(Map<String, Object> map, boolean b) throws IllegalArgumentException {
        return null;
    }

    public UriBuilder resolveTemplatesFromEncoded(Map<String, Object> map) {
        return null;
    }

    public URI buildFromMap(Map<String, ?> map) {
        return null;
    }

    public URI buildFromMap(Map<String, ?> map, boolean b) throws IllegalArgumentException, UriBuilderException {
        return null;
    }

    public URI buildFromEncodedMap(Map<String, ?> map) throws IllegalArgumentException, UriBuilderException {
        return null;
    }

    public URI build(Object ... objects) throws IllegalArgumentException, UriBuilderException {
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(this.scheme).append("://");
        }
        if (this.host != null) {
            sb.append(this.host);
            if (this.port != null && (this.scheme == null || "https".equals(this.scheme) && !"443".equals(this.port) || "http".equals(this.scheme) && !this.port.equals("80") || !this.scheme.startsWith("http"))) {
                sb.append(":").append(this.port);
            }
        }
        sb.append("/");
        AtomicInteger paramCounter = new AtomicInteger();
        if (this.path != null) {
            sb.append(this.path.stream().map(part -> {
                if (part.startsWith("{") && part.endsWith("}")) {
                    int pos = paramCounter.getAndIncrement();
                    if (pos > objects.length - 1) {
                        throw new IllegalArgumentException("Missing value for path parameter " + part);
                    }
                    return objects[pos].toString();
                }
                return part;
            }).collect(Collectors.joining("/")));
        }
        if (!this.queryParams.isEmpty()) {
            sb.append("?");
            for (Map.Entry e : this.queryParams.entrySet()) {
                if (e.getValue() == null) continue;
                for (String value : (List)e.getValue()) {
                    sb.append((String)e.getKey()).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8)).append("&");
                }
            }
        }
        if (this.fragment != null) {
            sb.append("#").append(this.fragment);
        }
        return URI.create(sb.toString());
    }

    public URI build(Object[] objects, boolean b) throws IllegalArgumentException, UriBuilderException {
        return null;
    }

    public URI buildFromEncoded(Object ... objects) throws IllegalArgumentException, UriBuilderException {
        return null;
    }

    public String toTemplate() {
        return null;
    }
}

